package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.param.GraphParam;
import cn.com.duiba.miria.monitor.api.vo.GraphVO;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface GraphService {

    /**
     * 查询所有图表窗口信息
     *
     * @return 包含指标的窗口
     */
    List<GraphVO> listAll();

    /**
     * 新增窗口
     *
     * @param graphParam 窗口参数
     * @throws BizException 业务异常
     */
    void insert(GraphParam graphParam) throws BizException;

    /**
     * 更新图表窗口
     *
     * @param graphParam 窗口参数
     */
    void update(GraphParam graphParam);

    /**
     * 根据id删除窗口
     *
     * @param id 窗口id
     */
    void delete(Long id);

}
