package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.param.K8sScaleUpParam;
import cn.com.duiba.miria.monitor.api.vo.K8sProviderVO;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface K8sScaleUpService {

    /**
     * 查询实例标签
     * @return cpu-1-2等
     */
    List<String> getInstanceLabels();

    /**
     * 查询所有集群列表
     *
     * @return 集群列表
     */
    List<K8sProviderVO> getK8sProviderVOs();

    /**
     * 扩容k8s集群
     *
     * @param k8sScaleUpParam 扩容配置
     */
    void commonScaleUp(K8sScaleUpParam k8sScaleUpParam) throws BizException;

}
