package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.entity.prometheus.MonitorChart;
import cn.com.duiba.miria.monitor.api.entity.prometheus.QueryResult;
import cn.com.duiba.miria.monitor.api.entity.prometheus.RealTimeQueryResult;
import cn.com.duiba.miria.monitor.api.param.MonitorChartParam;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface MonitorChartService {

    /**
     * 根据查询条件返回图表数据
     *
     * @param monitorChartParam 查询参数
     * @return 查询结果
     * @throws BizException 自定义异常
     */
    QueryResult queryRange(MonitorChartParam monitorChartParam) throws BizException;

    /**
     * 根据查询条件返回实时数据
     *
     * @param query     查询语句
     * @param timestamp 时间戳
     * @return 查询结果
     * @throws BizException 自定义异常
     */
    RealTimeQueryResult queryRealTime(String query, Long timestamp) throws BizException;

    /**
     * 查询容器监控图表数据
     *
     * @return 监控图表数据
     */
    List<MonitorChart> loadChartMetadata();

    /**
     * 查询宿主机监控图表数据
     *
     * @return 监控图表数据
     */
    List<MonitorChart> loadNodeChartInfo();

    /**
     * 查询flume监控图表数据
     *
     * @return 监控图表数据
     */
    List<MonitorChart> loadFlumeChartInfo();

}
