package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.entity.AppContainersRealTimeQuota;
import cn.com.duiba.miria.monitor.api.param.AppIpsParam;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface RemoteContainerRealTimeQuotaService {

    /**
     * 查询一批容器的压测监控数据
     *
     * @param appIpsParams 应用ip参数
     * @return 一批容器的压测监控数据
     * @throws BizException 查询异常
     */
    List<AppContainersRealTimeQuota> getAppContainersRealTimeQuotas(List<AppIpsParam> appIpsParams) throws BizException;

    /**
     * 根据应用名查询实例中最大的cpu使用率
     *
     * @param appName 应用名
     * @return 所有实例中最大的cpu使用率。如40.5代表最大使用率为40.5%
     * @throws BizException 查询异常
     */
    Float queryAppMaxCpuUsage(String appName) throws BizException;

    /**
     * 根据应用名查询所有实例的平均cpu使用率
     *
     * @param appName 应用名
     * @return 所有实例的平均cpu使用率。如30.5代表平均使用率为30.5%
     * @throws BizException 查询异常
     */
    Float queryAppAvgCpuUsage(String appName);

}
