package cn.com.duiba.miria.monitor.api.entity;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Date;

@Table(name = "tb_graph")
public class Graph implements Serializable {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 名称
     */
    @Column(name = "graph_name")
    private String graphName;

    /**
     * 类别，基础折线图等
     */
    @Column(name = "graph_type")
    private Byte graphType;

    /**
     * 类别，0:cpu、1:memory、2:network...,
     */
    @Column(name = "metric_type")
    private Byte metricType;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取名称
     *
     * @return graph_name - 名称
     */
    public String getGraphName() {
        return graphName;
    }

    /**
     * 设置名称
     *
     * @param graphName 名称
     */
    public void setGraphName(String graphName) {
        this.graphName = graphName == null ? null : graphName.trim();
    }

    /**
     * 获取类别，基础折线图等
     *
     * @return graph_type - 类别，基础折线图等
     */
    public Byte getGraphType() {
        return graphType;
    }

    /**
     * 设置类别，基础折线图等
     *
     * @param graphType 类别，基础折线图等
     */
    public void setGraphType(Byte graphType) {
        this.graphType = graphType;
    }

    /**
     * 获取类别，0:cpu、1:memory、2:network...,
     *
     * @return metric_type - 类别，0:cpu、1:memory、2:network...,
     */
    public Byte getMetricType() {
        return metricType;
    }

    /**
     * 设置类别，0:cpu、1:memory、2:network...,
     *
     * @param metricType 类别，0:cpu、1:memory、2:network...,
     */
    public void setMetricType(Byte metricType) {
        this.metricType = metricType;
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}