package cn.com.duiba.miria.monitor.api.entity;

import javax.persistence.*;
import java.util.Date;

@Table(name = "tb_time_scale_config")
public class TimeScaleConfig {
    /**
     * 主键id
     */
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 应用id
     */
    @Column(name = "app_id")
    private Long appId;

    /**
     * 扩容机器数
     */
    @Column(name = "increase_count")
    private Integer increaseCount;

    /**
     * 扩容开始时刻
     */
    @Column(name = "start_time")
    private String startTime;

    /**
     * 扩容结束时刻
     */
    @Column(name = "end_time")
    private String endTime;

    /**
     * 0：未开始，1：正在扩容，2:扩容成功，3:扩容失败
     */
    private Integer step;

    /**
     * 扩容成功的台数
     */
    @Column(name = "success_count")
    private Integer successCount;

    /**
     * 错误详情
     */
    @Column(name = "error_message")
    private String errorMessage;

    /**
     * 创建时间
     */
    @Column(name = "gmt_create")
    private Date gmtCreate;

    /**
     * 修改时间
     */
    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 获取主键id
     *
     * @return id - 主键id
     */
    public Long getId() {
        return id;
    }

    /**
     * 设置主键id
     *
     * @param id 主键id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取应用id
     *
     * @return app_id - 应用id
     */
    public Long getAppId() {
        return appId;
    }

    /**
     * 设置应用id
     *
     * @param appId 应用id
     */
    public void setAppId(Long appId) {
        this.appId = appId;
    }

    /**
     * 获取扩容机器数
     *
     * @return increase_count - 扩容机器数
     */
    public Integer getIncreaseCount() {
        return increaseCount;
    }

    /**
     * 设置扩容机器数
     *
     * @param increaseCount 扩容机器数
     */
    public void setIncreaseCount(Integer increaseCount) {
        this.increaseCount = increaseCount;
    }

    /**
     * 获取扩容开始时刻
     *
     * @return start_time - 扩容开始时刻
     */
    public String getStartTime() {
        return startTime;
    }

    /**
     * 设置扩容开始时刻
     *
     * @param startTime 扩容开始时刻
     */
    public void setStartTime(String startTime) {
        this.startTime = startTime == null ? null : startTime.trim();
    }

    /**
     * 获取扩容结束时刻
     *
     * @return end_time - 扩容结束时刻
     */
    public String getEndTime() {
        return endTime;
    }

    /**
     * 设置扩容结束时刻
     *
     * @param endTime 扩容结束时刻
     */
    public void setEndTime(String endTime) {
        this.endTime = endTime == null ? null : endTime.trim();
    }

    /**
     * 获取0：未开始，1：正在扩容，2:扩容成功，3:扩容失败
     *
     * @return step - 0：未开始，1：正在扩容，2:扩容成功，3:扩容失败
     */
    public Integer getStep() {
        return step;
    }

    /**
     * 设置0：未开始，1：正在扩容，2:扩容成功，3:扩容失败
     *
     * @param step 0：未开始，1：正在扩容，2:扩容成功，3:扩容失败
     */
    public void setStep(Integer step) {
        this.step = step;
    }

    /**
     * 获取扩容成功的台数
     *
     * @return success_count - 扩容成功的台数
     */
    public Integer getSuccessCount() {
        return successCount;
    }

    /**
     * 设置扩容成功的台数
     *
     * @param successCount 扩容成功的台数
     */
    public void setSuccessCount(Integer successCount) {
        this.successCount = successCount;
    }

    /**
     * 获取错误详情
     *
     * @return error_message - 错误详情
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * 设置错误详情
     *
     * @param errorMessage 错误详情
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage == null ? null : errorMessage.trim();
    }

    /**
     * 获取创建时间
     *
     * @return gmt_create - 创建时间
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * 设置创建时间
     *
     * @param gmtCreate 创建时间
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * 获取修改时间
     *
     * @return gmt_modified - 修改时间
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * 设置修改时间
     *
     * @param gmtModified 修改时间
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}