package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.param.AppTriggerTemplateParam;
import cn.com.duiba.miria.monitor.api.vo.AppTriggerTemplateVO;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface AppTriggerTemplateService {

    /**
     * 查询所有分组与报警模板关联信息
     *
     * @return 所有分组与报警模板关联信息
     */
    List<AppTriggerTemplateVO> listAll();

    /**
     * 新增关联关系，默认关联默认模板
     *
     * @param appTriggerTemplateParam 窗口参数
     */
    void insert(AppTriggerTemplateParam appTriggerTemplateParam) throws BizException;

    /**
     * 更新关联关系，默认关联默认模板
     *
     * @param appTriggerTemplateParam 窗口参数
     */
    void update(AppTriggerTemplateParam appTriggerTemplateParam) throws BizException;

    /**
     * 删除关联关系，默认关联默认模板
     *
     * @param id id
     */
    void delete(Long id);

}
