package cn.com.duiba.miria.monitor.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.monitor.api.entity.Metric;
import cn.com.duiba.miria.monitor.api.param.MetricParam;

import java.util.List;

/**
 * @author wrj
 */
@AdvancedFeignClient
public interface MetricService {

    /**
     * 返回所有监控指标
     *
     * @return 所有监控指标
     */
    List<Metric> listAll();


    /**
     * 新增监控指标
     *
     * @param metricParam 指标参数
     * @throws BizException 业务异常
     */
    void insert(MetricParam metricParam) throws BizException;

    /**
     * 修改监控指标
     *
     * @param metricParam 指标参数
     */
    void update(MetricParam metricParam);

    /**
     * 根据id删除监控指标
     *
     * @param id 监控指标id
     */
    void delete(Long id);

    List<String> listAllMetrics();

}
