package cn.com.duiba.miria.publish.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.io.Serializable;
import java.util.Map;

@Getter
public enum DeployStateEnum implements Serializable {

    CREATE(0,"创建","新创建的应用部署,需要在Jenkins中完成注册"),
    NORMAL(1,"正常","完成初始化后的日常状态，可以进行发布"),
    DEPLOYING(2,"发布中","发布状态"),
    ROLLBACK(4,"回滚中","回滚中");

    private static Map<Integer,DeployStateEnum> MAP = Maps.newHashMap();
    static {
        for(DeployStateEnum deployState:DeployStateEnum.values()){
            MAP.put(deployState.getCode(),deployState);
        }
    }

    DeployStateEnum(Integer code,String name,String description){
        this.code = code;
        this.name = name;
        this.description = description;
    }

    private Integer code;
    private String name;
    private String description;

    public static DeployStateEnum findByCode(Integer state){
        return MAP.get(state);
    }

}
