package cn.com.duiba.miria.publish.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.enums.AppAdminRelationTypeEnum;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@AdvancedFeignClient
public interface AppOwnerService {

    /**
     * 查询员工管理的App
     * @param adminId
     * @return
     */
     List<Long> getManagerAppIds(Long adminId);

    /**
     * 任命
     * @param adminId
     * @param appId
     */
     void appoint(Long adminId,Long appId);

    /**
     * 消除App上所有的Owner
     * @param appId
     */
     void cleanApp(Long appId);

    /**
     * 计数管理的应用数
     * @param adminIds
     * @return
     */
     Multiset<Long> getManagerAppNum(List<Long> adminIds);

    /**
     * 获取指定应用下所有Owner
     * @param appIds
     * @return
     */
     ArrayListMultimap<Long,Long> findOwnersByAppIds(List<Long> appIds);

}
