package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.enums.Environment;

import java.util.List;
import java.util.Set;


@AdvancedFeignClient
public interface AppPowerService {

     void setAdminEnvPower(Long adminId, Environment env, List<Long> appIds);

     Boolean hasPower(Long adminId, Environment env, Long appId);

     Set<Long> getHasPowerAppIds(Long adminId, Environment env);

    /**
     * 清除App上所有的发布权限
     * @param appId
     */
     void cleanAppPower(Long appId);

}
