/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/15.
 **/
package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.App;
import cn.com.duiba.miria.publish.api.domain.params.AppListPageParams;
import cn.com.duiba.miria.publish.api.domain.vo.PaginationVO;
import cn.com.duiba.miria.publish.api.exception.MiriaException;

import java.util.*;

@AdvancedFeignClient
public interface AppService {

    /**
     * 获取App分页列表
     * @param params
     * @return
     */
     PaginationVO<App> findApplicationPage(AppListPageParams params);

     Map<Long,App> appMap(Set<Long> ids);

     List<App> findByIds(Set<Long> ids);

    /**
     * 根据ming
     * @param name
     * @return
     */
     App findByName(String name);


     Integer createApp(App app) throws MiriaException;

     Integer updateApp(App app) throws MiriaException;

     App getAppById(Long AppId);

      List<App> findAllApps();

     List<App> findAppByAppName(String appName);

}
