/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/15.
 **/
package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.Publish;
import cn.com.duiba.miria.publish.api.enums.PublishResultEnum;
import cn.com.duiba.miria.publish.api.enums.PublishStateEnum;
import cn.com.duiba.miria.publish.api.exception.MiriaException;
import cn.com.duiba.miria.publish.api.params.BuildInfo;
import cn.com.duiba.miria.publish.api.vo.PublishProgressDto;

import java.util.List;
import java.util.Set;


@AdvancedFeignClient
public interface PublishService {

    /**
     * 查询一个部署下最近50条发布记录
     * @param deployIds
     * @return
     */
     List<Publish> getDeployPublishLog(Set<Long> deployIds);

    /**
     * 查询最近一条发布记录
     * @param deployId
     * @param type 发布类型  vm 容器
     * @return
     */
     Publish findEndPublish(Long deployId,Integer type);

     int createPublish(Publish publish);

     void updatePublishState(Long id, PublishStateEnum state);

     void updateVmPublishState(Long id, String state);

     void updatePublishResult(Long id, PublishResultEnum result, String message);

     void updateVmPublishResult(Long id, PublishResultEnum result, String message);

     void saveBuildInfo(BuildInfo buildInfo);

     Publish getPublishById(Long publishId);

     Publish queryPublishLog(Long publishId);

     PublishProgressDto getPublish(Long publishId) throws MiriaException;
}

