/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/15.
 **/
package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;


import cn.com.duiba.miria.common.api.entity.Zone;
import cn.com.duiba.miria.publish.api.exception.MiriaException;



import java.util.List;


@AdvancedFeignClient
public interface ZoneService {

    /**
     * 加载一个云环境下所有的可用区
     * @param cloudId
     * @return
     */
     List<Zone> findZoneByCloudId(Long cloudId);

    /**
     * 查询单个可用区
     * @param id
     * @return
     */
     Zone findZone(Long id);

     List<Zone> findByIds(List<Long> ids);


    /**
     * 创建可用区
     * @param zone
     * @return
     * @throws MiriaException
     */
     Integer createZone(Zone zone) throws MiriaException;

    /**
     * 更新可用区信息
     * @param zone
     * @return
     * @throws MiriaException
     */
     int updateZone(Zone zone) throws MiriaException;
}
