package cn.com.duiba.miria.publish.api.remoteservice.bo;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.data.PodInfo;
import cn.com.duiba.miria.common.api.entity.Deploy;
import cn.com.duiba.miria.common.api.entity.Publish;
import cn.com.duiba.miria.publish.api.domain.params.CreateDeployParams;

import cn.com.duiba.miria.publish.api.entity.PublishAuditEntity;
import cn.com.duiba.miria.publish.api.enums.Environment;
import cn.com.duiba.miria.publish.api.exception.MiriaException;
import cn.com.duiba.miria.publish.api.vo.DeployListVO;
import cn.com.duiba.miria.publish.api.vo.PrdDeployVO;
import com.alibaba.fastjson.JSONObject;
import io.fabric8.kubernetes.api.model.HostAlias;


import java.util.*;


@AdvancedFeignClient
public interface DeployBo {


    /**
     * 创建部署
     */
     void createDeploy(CreateDeployParams newDeploy) throws MiriaException;

     List<PrdDeployVO> findPrdDeployInfo(Long deployId) throws MiriaException;

    /**
     * 查询对应环境的部署配置
     * @param environment
     * @param cloudId
     * @return
     */
     List<DeployListVO> findDeployList(Long adminId,Environment environment, Long cloudId);

     List<PodInfo> getDeployPodsInfo(Long deployId);

     List<HostAlias> getDeployHostAlias(Long deployId);

     List<Publish> getDeployPublishLog(Long deployId);

    /**
     * 销毁
     */
     void destroyDeploy(Long deployId) throws MiriaException;

     PublishAuditEntity findLastPublishAudit(Deploy d);

      List<JSONObject> queryAuditStepList(PublishAuditEntity publishAuditEntity);



}
