package cn.com.duiba.miria.publish.api.remoteservice.bo;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.Deploy;
import cn.com.duiba.miria.common.api.entity.Publish;
import cn.com.duiba.miria.publish.api.domain.params.DoPulishParams;

import cn.com.duiba.miria.publish.api.exception.MiriaException;
import cn.com.duiba.sso.api.domain.dto.AdminDto;

@AdvancedFeignClient
public interface PublishBo {

    /**
     * 发布
     * @param params
     * @return
     * @throws MiriaException
     **/
     Long doPublish(AdminDto publisher, DoPulishParams params) throws MiriaException;
    /**
     * 审核发布
     * */
     void auditPublish (AdminDto adminDto,Long publishId,Integer status) throws MiriaException;


    /**
     * 回滚
     * @param publishId
     * @return
     * @throws MiriaException
     */
     Long rollbackPublish(AdminDto publisher,Long publishId) throws MiriaException;

    /**
     * 找到堡垒机发布的镜像
     * @param deploy
     * @return
     * @throws MiriaException
     */
     Publish getForTressDeployEndPublish(Deploy deploy) throws MiriaException;


}
