/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/28.
 **/
package cn.com.duiba.miria.publish.api.constant;


import cn.com.duiba.miria.publish.api.entity.PasswordEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.crypto.AesCipherService;

import java.util.List;

@Slf4j
public class EncryptionUtil {

    private static final String appkey = "sA1FGmFsXUHwPXrJOyWYfA==";

    public static final String PASSWORD = "sA1FGmFsXUHwPX";//用于回写页面的虚假密码

    private static AesCipherService aesCipherService = new AesCipherService();
    static{
        aesCipherService.setKeySize(Const.KEY_LEN);
    }


    public static String encrypt(String text) {

        if(StringUtils.isBlank(text)){
            return "";
        }
        if(StringUtils.equals(PASSWORD,text)){
            return null;
        }

        byte[] bytes = Base64.decode(appkey.getBytes());
        return aesCipherService.encrypt(text.getBytes(), bytes).toBase64();
    }

    public static String decrypt(String encrptText) {
        if(StringUtils.isBlank(encrptText)){
            return "";
        }
        byte[] bytes = Base64.decode(appkey.getBytes());
        return new String(aesCipherService.decrypt(Base64.decode(encrptText.getBytes()), bytes).getBytes());
    }

    public static void batchDecrypt(List<? extends PasswordEntity> list){
        for(PasswordEntity passwordEntity:list){
            decrypt(passwordEntity);
        }
    }

    public static <T extends PasswordEntity> void decrypt(T passwordEntity){
        if(passwordEntity==null){
            return;
        }
        String password = passwordEntity.getPassword();
        passwordEntity.setPassword(decrypt(password));
    }

}

