/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2018/5/22.
 **/
package cn.com.duiba.miria.publish.api.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.entity.ConfigMapEntity;
import cn.com.duiba.miria.publish.api.entity.ConfigMapTypeEntity;
import cn.com.duiba.miria.publish.api.exception.MiriaException;
import cn.com.duiba.miria.publish.api.so.ConfigMapSo;
import cn.com.duiba.miria.publish.api.vo.ConfigMapEntityVO;
import cn.com.duiba.miria.publish.api.vo.Page;

import java.util.List;
import java.util.Map;

@AdvancedFeignClient
public interface ConfigMapService {

     void createConfigMap(ConfigMapEntity configMap, Map<String, String> data) throws MiriaException;

     void modifyConfigMap(ConfigMapEntity configMap, Map<String, String> data) throws MiriaException ;

     void deleteConfigMap(Long configMapId) throws MiriaException ;

     List<ConfigMapEntityVO> getConfigMapInfo(Long configMapId) throws MiriaException ;

     Page getConfigMapList(ConfigMapSo configMapSo) throws Exception;

     List<ConfigMapEntity> getGlobalList();

     List<ConfigMapTypeEntity> configTypeList();


}

