package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.entity.Deploy;
import cn.com.duiba.miria.publish.api.domain.event.DeployCreateEvent;
import cn.com.duiba.miria.publish.api.domain.params.DeployConfig;
import cn.com.duiba.miria.publish.api.entity.prometheus.AppInfo;
import cn.com.duiba.miria.publish.api.enums.DeployStateEnum;
import cn.com.duiba.miria.publish.api.enums.Environment;
import cn.com.duiba.miria.publish.api.exception.MiriaException;



import java.util.*;


@AdvancedFeignClient
public interface DeployService {

    /**
     * 获取指定环境和云环境下的部署
     * @param environment
     * @param cloudId
     * @return
     */
     List<Deploy> findDeployByEnvAndCloudAndAppIds(Environment environment, Long cloudId, Set<Long> appIds);

    /**
     * 修改部署配置(堡垒和正式环境一致)
     * @param config
     */

     void updateDeployConfig(DeployConfig config);

    /**
     * 伸缩
     * @param deployId
     * @param podCount
     * @throws MiriaException
     */

     void scaleDeploy(Long deployId,Integer podCount);

     List<Deploy> findDeployByEnvAndCloudAndAppId(Environment environment, Long cloudId, Long appId);


     Deploy findNomalDeploy(Environment environment,Long cloudId,Long appId);

     Deploy findForterssDeploy(Environment environment,Long cloudId,Long appId);

     void updateDeployState(Long deployId,DeployStateEnum state);

    /**
     * 批量获取部署的状态
     * @param deployIds
     * @return
     */
     Map<Long,DeployStateEnum> getDeployState(List<Long> deployIds);

     void createDeploy(Deploy deploy) throws MiriaException;

    /**
     * 创建正式环境堡垒部署
     * @param event
     */

     void DeployCreateEventLister(DeployCreateEvent event);

     void validDeploy(Deploy deploy) throws MiriaException;

     Deploy getDeployById(Long deployId);

     void updateGitBranch(String gitBranch,Long deployId);

    /**
     * 根据环境id得到对应所有部署的应用名列表
     * @param envId
     * @return
     */
     List<AppInfo> findAppNamesByEnvId(long envId);
}

