package cn.com.duiba.miria.publish.api.remoteservice.bo;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import cn.com.duiba.miria.common.api.entity.Deploy;
import cn.com.duiba.miria.publish.api.enums.Environment;
import cn.com.duiba.miria.publish.api.exception.MiriaException;
import cn.com.duiba.miria.publish.api.vo.AppPowerVO;
import cn.com.duiba.sso.api.domain.dto.AdminDto;


import java.util.List;


@AdvancedFeignClient
public interface AppPowerBo {


    /**
     * 用户组下，用户对App拥有权限的情况
     * @param groupId
     * @param adminId
     * @param environment
     * @return
     */
     List<AppPowerVO> getGroupAdminAppPower(Long groupId, Long adminId, Environment environment);


    /**
     * 设置App权限
     * @param adminId
     * @param env
     * @param appIds
     */
     void setAdminEnvPower(Long groupId,Long adminId, Environment env, List<Long> appIds) throws MiriaException;


}
