package cn.com.duiba.miria.publish.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.util.Map;

@Getter
public enum PublishAuditStatusEnum {
    AUDIT(1,"待审核"),
    PASS(2,"通过"),
    NOT_PASS(3,"驳回"),
    GIVE_UP(4,"废弃");

    private static Map<Integer,PublishAuditStatusEnum> MAP_CAHCE = Maps.newHashMap();
    static{
        for(PublishAuditStatusEnum resultEnum:PublishAuditStatusEnum.values()){
            MAP_CAHCE.put(resultEnum.getCode(),resultEnum);
        }
    }

    private Integer code;
    private String name;

    PublishAuditStatusEnum(Integer code,String name){
        this.code = code;
        this.name = name;
    }

    public static PublishAuditStatusEnum findByCode(Integer code){
        return MAP_CAHCE.get(code);
    }
}
