package cn.com.duiba.miria.publish.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.io.Serializable;
import java.util.Map;

@Getter
public enum PublishResultEnum implements Serializable {

    ERROR(-1,"失败"),
    DOING(0,"发布中"),
    SUCCESS(1,"成功"),
    CANCEL(2,"取消");

    private static Map<Integer,PublishResultEnum> MAP_CAHCE = Maps.newHashMap();
    static{
        for(PublishResultEnum resultEnum:PublishResultEnum.values()){
            MAP_CAHCE.put(resultEnum.getStateResult(),resultEnum);
        }
    }

    private Integer stateResult;
    private String name;

    PublishResultEnum(Integer stateResult,String name){
        this.stateResult = stateResult;
        this.name = name;
    }

    public static PublishResultEnum findByResult(Integer stateResult){
        return MAP_CAHCE.get(stateResult);
    }

}
