package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.domain.event.DeployCreateEvent;
import cn.com.duiba.miria.publish.api.domain.params.AppInfo;
import cn.com.duiba.miria.publish.api.domain.params.DeployConfig;
import cn.com.duiba.miria.publish.api.entity.Deploy;
import cn.com.duiba.miria.publish.api.enums.DeployStateEnum;

import java.util.List;
import java.util.Map;
import java.util.Set;


@AdvancedFeignClient
public interface DeployService {

    /**
     * 获取指定环境和云环境下的部署
     *
     * @param envId
     * @param cloudId
     * @return
     */
    List<Deploy> findDeployByEnvAndCloudAndAppIds(Long envId, Long cloudId, Set<Long> appIds);

    /**
     * 修改部署配置(堡垒和正式环境一致)
     *
     * @param config
     */

    void updateDeployConfig(DeployConfig config);

    /**
     * 伸缩
     *
     * @param deployId
     * @param podCount
     * @throws BizException
     */

    void scaleDeploy(Long deployId, Integer podCount);

    List<Deploy> findDeployByEnvAndCloudAndAppId(Long envId, Long cloudId, Long appId);


    Deploy findNomalDeploy(Long envId, Long cloudId, Long appId);

    Deploy findForterssDeploy(Long envId, Long cloudId, Long appId);

    void updateDeployState(Long deployId, DeployStateEnum state);

    /**
     * 批量获取部署的状态
     *
     * @param deployIds
     * @return
     */
    Map<Long, DeployStateEnum> getDeployState(List<Long> deployIds);

    void createDeploy(Deploy deploy) throws BizException;


    void validDeploy(Deploy deploy) throws BizException;

    Deploy getDeployById(Long deployId);

    void updateGitBranch(String gitBranch, Long deployId);

    /**
     * 根据环境id得到对应所有部署的应用名列表
     *
     * @param envId
     * @return
     */
    List<AppInfo> findAppNamesByEnvId(long envId);

    String getDeployName(String appName, String deployType, String envAlias);

    void updateDeploy(Deploy insert, boolean b);
}

