package cn.com.duiba.miria.publish.api.domain.eventbus;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.Sets;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.EventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;

/**
 * Created by liuyao on 2017/6/20.
 * 事件总线
 */
@Component
public class PublishEventBus implements InitializingBean {

    private static final Logger log= LoggerFactory.getLogger(PublishEventBus.class);

    @Resource
    private ExecutorService executorService;
    @Resource
    private ApplicationContext applicationContext;

    private EventBus eventBus = new EventBus();
    private AsyncEventBus asyncEventBus;

    private Set<String> listenerNameSet = Sets.newHashSet();

    public void register(Object listener){
        if(Objects.equal(null,listener)) {
            return;
        }
        String listenerName = listener.getClass().getSimpleName();
        listenerNameSet.add(listenerName);
        eventBus.register(listener);
        asyncEventBus.register(listener);
        log.info(listenerName+"注册到事件总线");
    }

    /**
     * 发布事件
     * @param event
     */
    public void post(Object event){
        try {
            ValidatorTool.valid(event);
            AsyncEvent annotation = AnnotationUtils.findAnnotation(event.getClass(),AsyncEvent.class);
            if(annotation!=null){
                asyncEventBus.post(event);
            }else{
                eventBus.post(event);
            }
        }catch(Exception e){
            log.error("事件发布失败,事件类型:"+event.getClass().getSimpleName(), e);
            throw new SsoRunTimeException(e.getMessage());
        }
    }

    public String showAllListener(){
        Joiner joiner = Joiner.on(",").skipNulls();
        return joiner.join(listenerNameSet);
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        asyncEventBus = new AsyncEventBus(executorService);
        Collection<Object> objects = applicationContext.getBeansWithAnnotation(BizEventListener.class).values();
        for(Object listener:objects){
            register(listener);
        }
    }
}

