package cn.com.duiba.miria.publish.api.domain.eventbus;

import cn.com.duiba.miria.publish.api.exception.MiriaRunException;
import com.google.common.collect.Lists;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

/**
 * Created by liuyao on 2017/6/20.
 */
public class ValidatorTool {

    private static ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    /**
     * 获取校验的错误结果集
     * @param pojo
     * @param <T>
     * @return
     */
    public static <T>List<String> getValidatorErrorList(T pojo){
        Validator validator = factory.getValidator();
        Set<ConstraintViolation<T>> errorSet = validator.validate(pojo);
        if(errorSet.isEmpty()){
            return Collections.emptyList();
        }else{
            List<String> list = Lists.newLinkedList();
            Iterator<ConstraintViolation<T>> it = errorSet.iterator();
            while(it.hasNext()){
                list.add(it.next().getMessage());
            }
            return list;
        }
    }

    /**
     * 校验对象
     * @param pojo
     * @param <T>
     * @throws MiriaRunException
     */
    public static <T>void valid(T pojo) throws MiriaRunException {
        List<String> errorList = getValidatorErrorList(pojo);
        if(errorList.isEmpty()) {
            return;
        }
        throw new MiriaRunException(errorList.get(0));
    }

}

