package cn.com.duiba.miria.publish.api.entity;

import java.util.Date;
import javax.persistence.*;

@Table(name = "tb_perf_test_container")
public class TbPerfTestContainer {
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    /**
     * 场景id
     */
    @Column(name = "scene_id")
    private Long sceneId;

    /**
     * cpu核数
     */
    @Column(name = "cpu_core")
    private Integer cpuCore;

    /**
     * 内存
     */
    @Column(name = "perf_memory")
    private Integer perfMemory;

    /**
     * 类型0：施压机，1：被压机
     */
    @Column(name = "perf_type")
    private Integer perfType;

    /**
     * 1:启动中 2：启动完成 3.启动失败
     */
    @Column(name = "container_status")
    private Integer containerStatus;

    /**
     * 关联发布表的id
     */
    @Column(name = "publish_id")
    private Long publishId;

    /**
     * 发布失败原因
     */
    @Column(name = "error_message")
    private String errorMessage;

    /**
     * 数量
     */
    private Integer quantity;

    @Column(name = "gmt_create")
    private Date gmtCreate;

    @Column(name = "gmt_modified")
    private Date gmtModified;

    /**
     * 应用名称
     */
    @Column(name = "app_name")
    private String appName;

    /**
     * 解析域名
     */
    @Column(name = "perf_hosts")
    private String perfHosts;

    /**
     * @return id
     */
    public Long getId() {
        return id;
    }

    /**
     * @param id
     */
    public void setId(Long id) {
        this.id = id;
    }

    /**
     * 获取场景id
     *
     * @return scene_id - 场景id
     */
    public Long getSceneId() {
        return sceneId;
    }

    /**
     * 设置场景id
     *
     * @param sceneId 场景id
     */
    public void setSceneId(Long sceneId) {
        this.sceneId = sceneId;
    }

    /**
     * 获取cpu核数
     *
     * @return cpu_core - cpu核数
     */
    public Integer getCpuCore() {
        return cpuCore;
    }

    /**
     * 设置cpu核数
     *
     * @param cpuCore cpu核数
     */
    public void setCpuCore(Integer cpuCore) {
        this.cpuCore = cpuCore;
    }

    /**
     * 获取内存
     *
     * @return perf_memory - 内存
     */
    public Integer getPerfMemory() {
        return perfMemory;
    }

    /**
     * 设置内存
     *
     * @param perfMemory 内存
     */
    public void setPerfMemory(Integer perfMemory) {
        this.perfMemory = perfMemory;
    }

    /**
     * 获取类型0：施压机，1：被压机
     *
     * @return perf_type - 类型0：施压机，1：被压机
     */
    public Integer getPerfType() {
        return perfType;
    }

    /**
     * 设置类型0：施压机，1：被压机
     *
     * @param perfType 类型0：施压机，1：被压机
     */
    public void setPerfType(Integer perfType) {
        this.perfType = perfType;
    }

    /**
     * 获取1:启动中 2：启动完成 3.启动失败
     *
     * @return container_status - 1:启动中 2：启动完成 3.启动失败
     */
    public Integer getContainerStatus() {
        return containerStatus;
    }

    /**
     * 设置1:启动中 2：启动完成 3.启动失败
     *
     * @param containerStatus 1:启动中 2：启动完成 3.启动失败
     */
    public void setContainerStatus(Integer containerStatus) {
        this.containerStatus = containerStatus;
    }

    /**
     * 获取关联发布表的id
     *
     * @return publish_id - 关联发布表的id
     */
    public Long getPublishId() {
        return publishId;
    }

    /**
     * 设置关联发布表的id
     *
     * @param publishId 关联发布表的id
     */
    public void setPublishId(Long publishId) {
        this.publishId = publishId;
    }

    /**
     * 获取发布失败原因
     *
     * @return error_message - 发布失败原因
     */
    public String getErrorMessage() {
        return errorMessage;
    }

    /**
     * 设置发布失败原因
     *
     * @param errorMessage 发布失败原因
     */
    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage == null ? null : errorMessage.trim();
    }

    /**
     * 获取数量
     *
     * @return quantity - 数量
     */
    public Integer getQuantity() {
        return quantity;
    }

    /**
     * 设置数量
     *
     * @param quantity 数量
     */
    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    /**
     * @return gmt_create
     */
    public Date getGmtCreate() {
        return gmtCreate;
    }

    /**
     * @param gmtCreate
     */
    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    /**
     * @return gmt_modified
     */
    public Date getGmtModified() {
        return gmtModified;
    }

    /**
     * @param gmtModified
     */
    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    /**
     * 获取应用名称
     *
     * @return app_name - 应用名称
     */
    public String getAppName() {
        return appName;
    }

    /**
     * 设置应用名称
     *
     * @param appName 应用名称
     */
    public void setAppName(String appName) {
        this.appName = appName == null ? null : appName.trim();
    }

    /**
     * 获取解析域名
     *
     * @return perf_hosts - 解析域名
     */
    public String getPerfHosts() {
        return perfHosts;
    }

    /**
     * 设置解析域名
     *
     * @param perfHosts 解析域名
     */
    public void setPerfHosts(String perfHosts) {
        this.perfHosts = perfHosts == null ? null : perfHosts.trim();
    }
}