package cn.com.duiba.miria.publish.api.enums;

import com.google.common.collect.Maps;
import lombok.Getter;

import java.io.Serializable;
import java.util.Map;

/**
 * 维护发布过程的全集
 */
@Getter
public enum PublishStateEnum implements Serializable {

    AUDIT("audit","审核"),
    INIT("init","创建"),
    BUILDING("building","构建"),
    PUBLISHING("publishing","发布");

    private static Map<String,PublishStateEnum> MAP = Maps.newHashMap();
    static {
        for(PublishStateEnum state:PublishStateEnum.values()){
            MAP.put(state.getStateIndex(),state);
        }
    }

    private String stateIndex;
    private String name;

    PublishStateEnum(String stateIndex,String name){
        this.stateIndex = stateIndex;
        this.name = name;
    }

    public static PublishStateEnum findByIndex(String stateIndex){
        return MAP.get(stateIndex);
    }
}
