/**
 * Copyright 2017 Duiba Group. All Rights Reserved.
 * Created by kong bo on 2017/12/15.
 **/
package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.entity.Cluster;

import java.util.List;
import java.util.Map;


@AdvancedFeignClient
public interface ClusterService {

    void insertCluster(Cluster cluster);

    void updateCluster(Cluster cluster);

    List<Cluster> findByEnvId(Long envId);

    List<Cluster> findByK8sId(Long k8sId);

    /**
     * 查询每个k8s管控的集群总数
     *
     * @param k8sIds
     * @return
     */
    Map<Long, Integer> findK8sClusterCount(List<Long> k8sIds);

    /**
     * @param cloudId 云环境
     * @param envId   部署环境
     * @return
     */
    List<Cluster> findClusterByCloudIdAndEnvId(Long cloudId, Long envId);

    List<Cluster> findClusterByDeployId(Long deployId,Long envId);

    List<Cluster> findClusterByEnvId(Long envId);

    Cluster findSimpleCluster(Long id);

    List<Cluster>  findIdcCluster();
}
