package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.publish.api.domain.params.AppInfo;
import cn.com.duiba.miria.publish.api.domain.params.DeployConfig;
import cn.com.duiba.miria.publish.api.entity.Deploy;
import cn.com.duiba.miria.publish.api.entity.DeployExt;
import cn.com.duiba.miria.publish.api.entity.Publish;
import cn.com.duiba.miria.publish.api.enums.DeployStateEnum;

import java.util.List;
import java.util.Map;
import java.util.Set;


@AdvancedFeignClient
public interface DeployService {

    /**
     * 获取指定环境和云环境下的部署
     *
     * @param envId
     * @return
     */
    List<Deploy> findDeployByEnvAndCloudAndAppIds(Long envId,  Set<Long> appIds);

    /**
     * 修改部署配置(堡垒和正式环境一致)
     *
     * @param config
     */

    void updateDeployConfig(DeployConfig config);

    /**
     * 伸缩
     *
     * @param deployId
     * @param podCount
     * @throws BizException
     */

    void scaleDeploy(Long deployId, Integer podCount);

    List<Deploy> findDeployByEnvAndCloudAndAppId(Long envId,  Long appId);


    Deploy findNomalDeploy(Long envId,  Long appId);

    Deploy findForterssDeploy(Long envId, Long appId);

    void updateDeployState(Long deployId, DeployStateEnum state);

    /**
     * 批量获取部署的状态
     *
     * @param deployIds
     * @return
     */
    Map<Long, DeployStateEnum> getDeployState(List<Long> deployIds);

    void createDeploy(Deploy deploy, List<DeployExt> deployExts) throws BizException;


    void validDeploy(Deploy deploy) throws BizException;

    Deploy getDeployById(Long deployId);

    void updateGitBranch(String gitBranch, Long deployId);

    /**
     * 根据环境id得到对应所有部署的应用名列表
     *
     * @param envId
     * @return
     */
    List<AppInfo> findAppNamesByEnvId(long envId);

    String getDeployName(String appName, String deployType, String envAlias,Publish publish);

    String getSceneTestDeployName(String appName,String deployType,String envAlias,Long sceneId);

    String getPerfTestDeployName(String appName,  String envAlias);

    String getContainerStartDeployName(String appName,  String envAlias,Integer type,Long key);

    void updateDeploy(Deploy insert, List<DeployExt> deployExts, boolean b) throws BizException;

    void updateDeployNormal(Deploy deploy);

    Set<String> findDeployedAppNames();

    Set<Deploy> findNormalDeploy();

    void releaseDeployment(Long deployId,List<DeployExt> deployExts) throws BizException;

    Deploy getDeployByAppId(Long appId);

    List<Deploy> findAllNormalDeploy();

    void updateAllJenkinsModel(Long adminId);

    void deleteAllJenkinsModel(Long adminId);

    void deletePod(Long k8sId,String podName,Long adminId,Long deployId) throws BizException;

    List<Deploy> findByAppId(Long id);

    void  upgrade(Deploy deploy);

    String getContainerStartLable(String appname, String startType, Long startKey);
    /**
     * 暂停部署
     * */
    void pauseDeploy(Long deployId) throws BizException;
    /**
     * 取消暂停 重新开始部署
     * */
    void startDeploy(Long deployId) throws BizException;

    Boolean deployPauseType(Long deployId);

}

