package cn.com.duiba.miria.publish.api.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.miria.common.api.data.PodInfo;
import cn.com.duiba.miria.publish.api.entity.SceneTestApp;
import cn.com.duiba.miria.publish.api.entity.TbSceneTest;
import cn.com.duiba.miria.publish.api.enums.PublishResultEnum;
import cn.com.duiba.miria.publish.api.vo.SceneTestVO;
import cn.com.duiba.wolf.perf.timeprofile.RequestTool;

import java.util.List;

@AdvancedFeignClient
public interface SceneTestService {
      /**
       * 发布场景
       * */
      void publishScene(Long adminId, String sceneName, List<SceneTestApp> sceneTestAppList) throws BizException;

      void addApp(Long adminId,Long sceneId,List<SceneTestApp> sceneTestAppList) throws BizException;
      /**
       * 释放场景
       * */
      void releaseScene(Long adminId,Long sceneId) throws BizException;
      /**
       * 释放应用
       * */
      void releaseSceneApp(Long adminId,Long sceneId,Long appId) throws BizException;
      /**
       * 查询可见范围内的场景
       * */
      List<TbSceneTest> querySceneListByAdminId(Long adminId);
      /**
       * 根据场景id查询对应场景的详情
       * */
      SceneTestVO querySceneInfoById(Long sceneId) throws BizException;
      /**
       * 更新场景下某个应用的发布状态
       * */
      void updateScenePublishStatus(Long sceneId, Long publishId, Integer publishStateResult) throws BizException;
      /**
       *
       * 重新发布场景下某个应用
       */
      void rePublishScene(Long adminId,Long sceneId,Long publishId) throws BizException;
      /**
       * 根据发布id和对应状态来查询对应场景
       * */
      TbSceneTest querySceneByPublishIdAndState(Long publishId,Integer sceneState);
      /**
       * 根据场景状态批量查询场景
       * */
      List<TbSceneTest>  queryScenesByState(Integer sceneState);
      /**
       * 根据主键更新场景信息
       * */
      void updateScene(TbSceneTest tbSceneTest);
      /**
       *查询pod信息
       * */
      List<PodInfo> getSceneContaionerInfo(Long sceneId,Long publishId, String appName);

      /**
       * 根据发布id修改正在发布的场景状态
       * */
      void updatePublishingSceneStatusByPublishId(Long publishId,Integer publishStateResult);
      /**
       * 删除已经销毁的场景
       * */
      void deleteDestroyScene(Long adminId,Long sceneId) throws  BizException;
      /**
       * 修改分支
       * */
      void updateSceneBranch(Long adminId,Long sceneId,Long publishId,String branch)throws BizException;

      Boolean isSceneTest(Long publishId);

}
