package cn.com.duiba.mybatis.plus.join.method.mp;

import com.baomidou.mybatisplus.core.metadata.MPJTableInfoHelper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlScriptUtils;
import cn.com.duiba.mybatis.plus.join.toolkit.Constant;
import org.apache.ibatis.mapping.MappedStatement;

/**
 * SelectList 兼容MP原生方法
 */
public class SelectList extends com.baomidou.mybatisplus.core.injector.methods.SelectList implements TableAlias {

    @Override
    public MappedStatement injectMappedStatement(Class<?> mapperClass, Class<?> modelClass, TableInfo tableInfo) {
        return super.injectMappedStatement(mapperClass, modelClass,
                MPJTableInfoHelper.copyAndSetTableName(tableInfo, getTableName(tableInfo)));
    }

    @Override
    protected String sqlWhereEntityWrapper(boolean newLine, TableInfo table) {
        return SqlScriptUtils.convertChoose(String.format("%s == null or !%s", Constant.PARAM_TYPE, Constant.PARAM_TYPE),
                super.sqlWhereEntityWrapper(newLine, table), mpjSqlWhereEntityWrapper(newLine, table));
    }
}
