/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mybatis.plus.join.base.mapper;

import cn.com.duiba.mybatis.plus.join.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.enums.SqlKeyword;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.MPJMappingWrapper;
import com.baomidou.mybatisplus.core.metadata.MPJTableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.MPJTableInfo;
import com.baomidou.mybatisplus.core.metadata.MPJTableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public interface MPJDeepMapper<T>
extends BaseMapper<T> {
    default public T selectByIdDeep(Serializable id) {
        return (T)this.queryMapping(this.selectById(id), null);
    }

    default public <R> T selectByIdDeep(Serializable id, SFunction<T, R> ... property) {
        return (T)this.queryMapping(this.selectById(id), Arrays.asList(property));
    }

    default public <R> T selectByIdDeep(Serializable id, List<SFunction<T, R>> property) {
        return (T)this.queryMapping(this.selectById(id), property);
    }

    default public List<T> selectBatchIdsDeep(Collection<? extends Serializable> idList) {
        return this.queryMapping(this.selectBatchIds(idList), (List)null);
    }

    default public <R> List<T> selectBatchIdsDeep(Collection<? extends Serializable> idList, SFunction<T, R> ... property) {
        return this.queryMapping(this.selectBatchIds(idList), Arrays.asList(property));
    }

    default public <R> List<T> selectBatchIdsDeep(Collection<? extends Serializable> idList, List<SFunction<T, R>> property) {
        return this.queryMapping(this.selectBatchIds(idList), property);
    }

    default public List<T> selectByMapDeep(Map<String, Object> columnMap) {
        return this.queryMapping(this.selectByMap(columnMap), (List)null);
    }

    default public <R> List<T> selectByMapDeep(Map<String, Object> columnMap, SFunction<T, R> ... property) {
        return this.queryMapping(this.selectByMap(columnMap), Arrays.asList(property));
    }

    default public <R> List<T> selectByMapDeep(Map<String, Object> columnMap, List<SFunction<T, R>> property) {
        return this.queryMapping(this.selectByMap(columnMap), property);
    }

    default public T selectOneDeep(Wrapper<T> queryWrapper) {
        return (T)this.queryMapping(this.selectOne(queryWrapper), null);
    }

    default public <R> T selectOneDeep(Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        return (T)this.queryMapping(this.selectOne(queryWrapper), Arrays.asList(property));
    }

    default public <R> T selectOneDeep(Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        return (T)this.queryMapping(this.selectOne(queryWrapper), property);
    }

    default public List<T> selectListDeep(Wrapper<T> queryWrapper) {
        return this.queryMapping(this.selectList(queryWrapper), (List)null);
    }

    default public <R> List<T> selectListDeep(Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        return this.queryMapping(this.selectList(queryWrapper), Arrays.asList(property));
    }

    default public <R> List<T> selectListDeep(Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        return this.queryMapping(this.selectList(queryWrapper), property);
    }

    default public List<Map<String, Object>> selectMapsDeep(Class<T> clazz, Wrapper<T> queryWrapper) {
        return this.queryMapMapping(this.selectMaps(queryWrapper), clazz, null);
    }

    default public <R> List<Map<String, Object>> selectMapsDeep(Class<T> clazz, Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        return this.queryMapMapping(this.selectMaps(queryWrapper), clazz, Arrays.asList(property));
    }

    default public <R> List<Map<String, Object>> selectMapsDeep(Class<T> clazz, Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        return this.queryMapMapping(this.selectMaps(queryWrapper), clazz, property);
    }

    default public <E extends IPage<T>> E selectPageDeep(E page, Wrapper<T> queryWrapper) {
        IPage e = this.selectPage(page, queryWrapper);
        this.queryMapping(e.getRecords(), (List)null);
        return (E)e;
    }

    default public <R, E extends IPage<T>> E selectPageDeep(E page, Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        IPage e = this.selectPage(page, queryWrapper);
        this.queryMapping(e.getRecords(), Arrays.asList(property));
        return (E)e;
    }

    default public <R, E extends IPage<T>> E selectPageDeep(E page, Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        IPage e = this.selectPage(page, queryWrapper);
        this.queryMapping(e.getRecords(), property);
        return (E)e;
    }

    default public <R, E extends IPage<Map<String, Object>>> E selectMapsPageDeep(E page, Class<T> clazz, Wrapper<T> queryWrapper) {
        IPage e = this.selectMapsPage(page, queryWrapper);
        this.queryMapMapping(e.getRecords(), clazz, null);
        return (E)e;
    }

    default public <R, E extends IPage<Map<String, Object>>> E selectMapsPageDeep(E page, Class<T> clazz, Wrapper<T> queryWrapper, SFunction<T, R> ... property) {
        IPage e = this.selectMapsPage(page, queryWrapper);
        this.queryMapMapping(e.getRecords(), clazz, Arrays.asList(property));
        return (E)e;
    }

    default public <R, E extends IPage<Map<String, Object>>> E selectMapsPageDeep(E page, Class<T> clazz, Wrapper<T> queryWrapper, List<SFunction<T, R>> property) {
        IPage e = this.selectMapsPage(page, queryWrapper);
        this.queryMapMapping(e.getRecords(), clazz, property);
        return (E)e;
    }

    default public <R> T queryMapping(T t, List<SFunction<T, R>> property) {
        if (t == null) {
            return null;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(t.getClass());
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(property);
            List list = hasProperty ? property.stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                Object obj;
                if (hasProperty && !list.contains(fieldInfo.getProperty()) || (obj = fieldInfo.thisFieldGet(t)) == null) continue;
                List joinList = (List)fieldInfo.getJoinMapper().mappingWrapperConstructor(fieldInfo.isFieldIsMap(), SqlKeyword.EQ, fieldInfo.getJoinColumn(), obj, fieldInfo);
                this.bindData(t, fieldInfo, joinList);
                fieldInfo.removeJoinField(joinList);
            }
        }
        return t;
    }

    default public <R> Map<String, Object> queryMapMapping(Map<String, Object> map, Class<T> clazz, List<SFunction<T, R>> property) {
        if (CollectionUtils.isEmpty(map)) {
            return map;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(clazz);
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(property);
            List list = hasProperty ? property.stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                Object obj;
                if (hasProperty && !list.contains(fieldInfo.getProperty()) || (obj = map.get(fieldInfo.getThisMapKey())) == null) continue;
                List joinList = (List)fieldInfo.getJoinMapper().mappingWrapperConstructor(fieldInfo.isFieldIsMap(), SqlKeyword.EQ, fieldInfo.getJoinColumn(), obj, fieldInfo);
                this.bindMap(map, fieldInfo, joinList);
                fieldInfo.removeJoinField(joinList);
            }
        }
        return map;
    }

    default public <R> List<T> queryMapping(List<T> list, List<SFunction<T, R>> property) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(list.get(0).getClass());
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(property);
            List listProperty = hasProperty ? property.stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                List itemList;
                if (hasProperty) {
                    if (!listProperty.contains(fieldInfo.getProperty())) continue;
                }
                if (CollectionUtils.isNotEmpty(itemList = list.stream().map(fieldInfo::thisFieldGet).collect(Collectors.toList()))) {
                    List joinList = (List)fieldInfo.getJoinMapper().mappingWrapperConstructor(fieldInfo.isMappingEntity() && fieldInfo.isFieldIsMap(), SqlKeyword.IN, fieldInfo.getJoinColumn(), itemList, fieldInfo);
                    list.forEach(i -> this.bindData(i, fieldInfo, joinList));
                    fieldInfo.removeJoinField(joinList);
                    continue;
                }
                list.forEach(i -> fieldInfo.fieldSet(i, new ArrayList()));
            }
        }
        return list;
    }

    default public <R> List<Map<String, Object>> queryMapMapping(List<Map<String, Object>> list, Class<T> clazz, List<SFunction<T, R>> property) {
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        MPJTableInfo tableInfo = MPJTableInfoHelper.getTableInfo(clazz);
        if (tableInfo.isHasMappingOrField()) {
            boolean hasProperty = CollectionUtils.isNotEmpty(property);
            List listProperty = hasProperty ? property.stream().map(LambdaUtils::getName).collect(Collectors.toList()) : null;
            for (MPJTableFieldInfo fieldInfo : tableInfo.getFieldList()) {
                if (hasProperty && !listProperty.contains(fieldInfo.getProperty())) continue;
                List itemList = list.stream().map(m -> m.get(fieldInfo.getThisMapKey())).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(itemList)) {
                    List joinList = (List)fieldInfo.getJoinMapper().mappingWrapperConstructor(fieldInfo.isMappingEntity() && fieldInfo.isFieldIsMap(), SqlKeyword.IN, fieldInfo.getJoinColumn(), itemList, fieldInfo);
                    list.forEach(i -> this.bindMap((Map<String, Object>)i, fieldInfo, joinList));
                    fieldInfo.removeJoinField(joinList);
                    continue;
                }
                list.forEach(i -> i.put(fieldInfo.getField().getName(), new ArrayList()));
            }
        }
        return list;
    }

    default public void bindData(T t, MPJTableFieldInfo fieldInfo, List<?> joinList) {
        if (fieldInfo.isMappingEntity()) {
            List list = joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(fieldInfo.thisFieldGet(t))).collect(Collectors.toList());
            MPJTableFieldInfo.bind(fieldInfo, t, list);
        }
        if (fieldInfo.isMappingField()) {
            MPJTableFieldInfo.bind(fieldInfo, t, joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(fieldInfo.thisFieldGet(t))).map(fieldInfo::bindFieldGet).collect(Collectors.toList()));
        }
    }

    default public void bindMap(Map<String, Object> t, MPJTableFieldInfo fieldInfo, List<?> joinList) {
        List list = null;
        if (fieldInfo.isMappingEntity()) {
            list = fieldInfo.isFieldIsMap() ? joinList.stream().filter(j -> j.get(fieldInfo.getJoinMapKey()).equals(t.get(fieldInfo.getThisMapKey()))).collect(Collectors.toList()) : joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(t.get(fieldInfo.getThisMapKey()))).collect(Collectors.toList());
        }
        if (fieldInfo.isMappingField()) {
            list = joinList.stream().filter(j -> fieldInfo.joinFieldGet(j).equals(t.get(fieldInfo.getThisMapKey()))).map(fieldInfo::bindFieldGet).collect(Collectors.toList());
        }
        MPJTableFieldInfo.bindMap(fieldInfo, t, list);
    }

    default public Object mappingWrapperConstructor(boolean selectMap, SqlKeyword keyword, String column, Object val, MPJTableFieldInfo fieldInfo) {
        MPJMappingWrapper infoWrapper = fieldInfo.getWrapper();
        MappingQuery wrapper = new MappingQuery();
        if (infoWrapper.isHasCondition()) {
            infoWrapper.getConditionList().forEach(c -> wrapper.addCondition(true, c.getColumn(), c.getKeyword(), (Object)c.getVal()));
        }
        wrapper.eq(SqlKeyword.EQ == keyword, column, val);
        if (infoWrapper.isHasFirst()) {
            wrapper.first(infoWrapper.getFirst());
        }
        if (infoWrapper.isHasOrderByAsc()) {
            infoWrapper.getOrderByAsc().forEach(arg_0 -> wrapper.orderByAsc(arg_0));
        }
        if (infoWrapper.isHasOrderByDesc()) {
            infoWrapper.getOrderByAsc().forEach(arg_0 -> wrapper.orderByDesc(arg_0));
        }
        if (infoWrapper.isHasLast()) {
            wrapper.last(infoWrapper.getLast());
        }
        if (SqlKeyword.IN == keyword) {
            wrapper.in(column, (List)val);
        }
        if (infoWrapper.isHasSelect()) {
            wrapper.select(new String[]{infoWrapper.getSelect()});
        }
        if (infoWrapper.isHasApply()) {
            infoWrapper.getApplyList().forEach(a -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)wrapper.apply(a.getSql(), a.getVal());
            });
        }
        if (selectMap) {
            return this.selectMaps((Wrapper)wrapper);
        }
        return this.selectList((Wrapper)wrapper);
    }

    public static class MappingQuery<T>
    extends QueryWrapper<T> {
        public QueryWrapper<T> addCondition(boolean condition, String column, SqlKeyword sqlKeyword, Object val) {
            return (QueryWrapper)super.addCondition(condition, (Object)column, sqlKeyword, val);
        }
    }
}

