/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mybatis.plus.join.config;

import cn.com.duiba.mybatis.plus.join.exception.MPJException;
import cn.com.duiba.mybatis.plus.join.injector.MPJSqlInjector;
import cn.com.duiba.mybatis.plus.join.interceptor.MPJInterceptor;
import com.baomidou.mybatisplus.core.injector.ISqlInjector;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.plugin.InterceptorChain;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

public class InterceptorConfig
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Log logger = LogFactory.getLog(InterceptorConfig.class);
    @Autowired(required=false)
    private List<SqlSessionFactory> sqlSessionFactoryList;
    @Autowired
    private MPJInterceptor mpjInterceptor;
    @Autowired(required=false)
    private ISqlInjector iSqlInjector;

    public void onApplicationEvent(ApplicationReadyEvent event) {
        if (CollectionUtils.isNotEmpty(this.sqlSessionFactoryList)) {
            try {
                for (SqlSessionFactory factory : this.sqlSessionFactoryList) {
                    Field interceptorChain = Configuration.class.getDeclaredField("interceptorChain");
                    interceptorChain.setAccessible(true);
                    InterceptorChain chain = (InterceptorChain)interceptorChain.get(factory.getConfiguration());
                    Field interceptors = InterceptorChain.class.getDeclaredField("interceptors");
                    interceptors.setAccessible(true);
                    List list = (List)interceptors.get(chain);
                    if (CollectionUtils.isNotEmpty((Collection)list)) {
                        if (list.get(list.size() - 1) == this.mpjInterceptor) continue;
                        list.removeIf(i -> i == this.mpjInterceptor);
                        list.add(this.mpjInterceptor);
                        continue;
                    }
                    list.add(this.mpjInterceptor);
                }
            }
            catch (Exception ignored) {
                throw new MPJException("mpjInterceptor exception");
            }
        }
        if (this.iSqlInjector != null && !(this.iSqlInjector instanceof MPJSqlInjector)) {
            logger.error("sql\u6ce8\u5165\u5668\u672a\u7ee7\u627f MPJSqlInjector -> " + this.iSqlInjector.getClass());
        }
    }
}

