/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.mybatis.plus.join.interceptor;

import cn.com.duiba.mybatis.plus.join.interfaces.MPJBaseJoin;
import cn.com.duiba.mybatis.plus.join.method.MPJResultType;
import com.baomidou.mybatisplus.core.metadata.MPJTableInfo;
import com.baomidou.mybatisplus.core.metadata.MPJTableInfoHelper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.ResultMapping;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class MPJInterceptor
implements Interceptor {
    private static final Log logger = LogFactory.getLog(MPJInterceptor.class);
    private static final List<ResultMapping> EMPTY_RESULT_MAPPING = new ArrayList<ResultMapping>(0);
    private static final Map<String, Map<Configuration, MappedStatement>> MS_CACHE = new ConcurrentHashMap<String, Map<Configuration, MappedStatement>>();

    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        if (args[0] instanceof MappedStatement) {
            MappedStatement ms = (MappedStatement)args[0];
            if (args[1] instanceof Map) {
                ResultMap resultMap;
                List list;
                Class clazz;
                Object ew;
                Map map = (Map)args[1];
                Object v0 = ew = map.containsKey("ew") ? map.get("ew") : null;
                if (!map.containsKey("paramType_Gr8re1Ee")) {
                    map.put("paramType_Gr8re1Ee", Objects.nonNull(ew) && ew instanceof MPJBaseJoin);
                } else {
                    logger.warn(String.format("\u8bf7\u4e0d\u8981\u4f7f\u7528MPJ\u9884\u7559\u53c2\u6570\u540d %s", "paramType_Gr8re1Ee"));
                }
                if (CollectionUtils.isNotEmpty((Map)map) && map.containsKey("resultTypeClass_Eg1sG") && Objects.nonNull(clazz = (Class)map.get("resultTypeClass_Eg1sG")) && CollectionUtils.isNotEmpty((Collection)(list = ms.getResultMaps())) && (resultMap = (ResultMap)list.get(0)).getType() == MPJResultType.class) {
                    args[0] = this.newMappedStatement(ms, clazz);
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return null;
    }

    public void setProperties(Properties properties) {
    }

    public MappedStatement newMappedStatement(MappedStatement ms, Class<?> resultType) {
        MappedStatement statement;
        String id = ms.getId() + "_" + resultType.getName();
        Map<Configuration, MappedStatement> statementMap = MS_CACHE.get(id);
        if (CollectionUtils.isNotEmpty(statementMap) && Objects.nonNull(statement = statementMap.get(ms.getConfiguration()))) {
            return statement;
        }
        MappedStatement.Builder builder = new MappedStatement.Builder(ms.getConfiguration(), id, ms.getSqlSource(), ms.getSqlCommandType()).resource(ms.getResource()).fetchSize(ms.getFetchSize()).statementType(ms.getStatementType()).keyGenerator(ms.getKeyGenerator()).timeout(ms.getTimeout()).parameterMap(ms.getParameterMap()).resultSetType(ms.getResultSetType()).cache(ms.getCache()).flushCacheRequired(ms.isFlushCacheRequired()).useCache(ms.isUseCache());
        if (ms.getKeyProperties() != null && ms.getKeyProperties().length != 0) {
            builder.keyProperty(String.join((CharSequence)",", ms.getKeyProperties()));
        }
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(this.newResultMap(ms, resultType));
        builder.resultMaps(resultMaps);
        MappedStatement mappedStatement = builder.build();
        if (statementMap == null) {
            statementMap = new ConcurrentHashMap<Configuration, MappedStatement>();
            MS_CACHE.put(id, statementMap);
        }
        statementMap.put(ms.getConfiguration(), mappedStatement);
        return mappedStatement;
    }

    private ResultMap newResultMap(MappedStatement ms, Class<?> resultType) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(resultType);
        if (tableInfo != null && tableInfo.isAutoInitResultMap() && tableInfo.getEntityType() == resultType) {
            return ms.getConfiguration().getResultMap(tableInfo.getResultMap());
        }
        MPJTableInfo infoDTO = MPJTableInfoHelper.getTableInfo(resultType);
        if (infoDTO == null) {
            infoDTO = MPJTableInfoHelper.initTableInfo(ms.getConfiguration(), ms.getId().substring(0, ms.getId().lastIndexOf(".")), resultType, null);
        }
        if (infoDTO.getTableInfo().isAutoInitResultMap()) {
            return ms.getConfiguration().getResultMap(infoDTO.getTableInfo().getResultMap());
        }
        return new ResultMap.Builder(ms.getConfiguration(), ms.getId(), resultType, EMPTY_RESULT_MAPPING).build();
    }
}

