package cn.com.duiba.nezha.alg.alg.alg;


import cn.com.duiba.nezha.alg.alg.cost.BackendCostOptimizer;
import cn.com.duiba.nezha.alg.alg.vo.BackendAdvertStatDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.alg.vo.StatDo;

import java.util.HashMap;
import java.util.Map;

public class BackendCostOptAlg {
    /**
     * 后端转化，可优化后端行为&广告认定
     *
     * @param appAdvertStatMap
     * @param globalAdvertStatMap
     * @return （广告ID、后端转化数据类型、统计信息）
     */
    public static Map<Long, BackendAdvertStatDo> getBackendAdvertStatInfo(Map<Long, StatDo> appAdvertStatMap,
                                                                          Map<Long, StatDo> globalAdvertStatMap) {
        return BackendCostOptimizer.getBackendAdvertStatInfo(appAdvertStatMap, globalAdvertStatMap);
    }

    /**
     * 广告后端转化优化-智能竞价因子
     *
     * @param advertPreInfo    预估数据
     * @param advertStatInfo   统计数据
     * @param advertBudgetInfo 预算消耗数据 ** 新增 **
     * @return 优化因子
     */
    public static <T> Map<T, Double> getBackendAdvertInfo(Map<T, Double> advertPreInfo,
                                                          Map<T, BackendAdvertStatDo> advertStatInfo,
                                                          Map<T, BudgetSmoothDo> advertBudgetInfo) {
        return BackendCostOptimizer.getBackendAdvertInfo(advertPreInfo, advertStatInfo, advertBudgetInfo);
    }

    /**
     * 广告后端转化优化-智能竞价因子
     *
     * @param advertPreInfo    预估数据
     * @param advertStatInfo   统计数据
     * @param advertBudgetInfo 预算消耗数据 ** 新增 **
     * @return 优化因子
     */
    public static Double getBackendAdvertInfo(Double advertPreInfo,
                                              BackendAdvertStatDo advertStatInfo,
                                              BudgetSmoothDo advertBudgetInfo) {
        Map<Long, Double> advertPreInfoMap = new HashMap<>();
        advertPreInfoMap.put(1L, advertPreInfo);

        Map<Long, BackendAdvertStatDo> advertStatInfoMap = new HashMap<>();
        advertStatInfoMap.put(1L, advertStatInfo);

        Map<Long, BudgetSmoothDo> advertBudgetInfoMap = new HashMap<>();
        advertBudgetInfoMap.put(1L, advertBudgetInfo);
        Map<Long, Double> ret = BackendCostOptimizer.getBackendAdvertInfo(advertPreInfoMap, advertStatInfoMap, advertBudgetInfoMap);

        return ret.get(1L);
    }


}
