package cn.com.duiba.nezha.alg.alg.budget;

import cn.com.duiba.nezha.alg.alg.vo.BudgetDo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetInfo;
import cn.com.duiba.nezha.alg.alg.vo.BudgetSmoothDo;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.DateUtil;
import com.alibaba.fastjson.JSON;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BudgetSmooth {

    public static double[] reqDist = {0,
            3, 4.5, 5.5, 6.5, 7.5, 9.5,
            13, 17.5, 22, 27, 32, 37,
            43, 48.5, 53.5, 58.5, 63.5, 68.5,
            74, 79.5, 85.5, 91, 96, 100};

    /**
     * @param advertBudgetInfoMap 广告预算消耗对象Map
     * @return <广告，消耗速度>
     */
    public static<T> Map<T, BudgetSmoothDo> getBudgetRatio(Map<T, BudgetInfo> advertBudgetInfoMap) {
        Map<T, BudgetSmoothDo> ret = new HashMap<>();
        if (AssertUtil.isNotEmpty(advertBudgetInfoMap)) {
            advertBudgetInfoMap.forEach((advert, budgetInfo) -> ret.put(advert, getRatio(budgetInfo))
            );
        }
        return ret;
    }

    /**
     * @param advertBudget 广告预算消耗对象Map
     * @return <广告，消耗速度>
     */
    public static BudgetSmoothDo getRatio(BudgetInfo advertBudget) {
        BudgetSmoothDo ret = null;
        if (advertBudget != null) {

            ret = getMaxRatio(ret, getBudgetSmooth(advertBudget.getAccountBudgetInfo(), false, 1L));

            ret = getMaxRatio(ret, getBudgetSmooth(advertBudget.getAdvertBudgetInfo(), false, 2L));

            ret = getMaxRatio(ret, getBudgetSmooth(advertBudget.getOrientationBudgetInfo(), false, 3L));

            ret = getMaxRatio(ret, getBudgetSmooth(advertBudget.getOrientationAndAppBudgetInfo(), false, 4L));

            ret = getMaxRatio(ret, getBudgetSmooth(advertBudget.getOrientationAndTimeBudgetInfo(), true, 5L));


        }
        return ret;
    }


    public static BudgetSmoothDo getMaxRatio(BudgetSmoothDo cMaxRatio, BudgetSmoothDo nRatio) {
        BudgetSmoothDo ret = cMaxRatio;


        if (nRatio != null) {
            if (cMaxRatio == null) {
                ret = nRatio;
            } else {
                if (cMaxRatio.getRatio() == null && nRatio.getRatio() != null) {
                    ret = nRatio;
                }
                if (cMaxRatio.getRatio() != null && nRatio.getRatio() != null) {
                    ret = cMaxRatio.getRatio() > nRatio.getRatio() ? cMaxRatio : nRatio;
                }

            }
        }

        return ret;
    }


    /**
     * @param budget 广告预算消耗对象Map
     * @return <广告，消耗速度>
     */
    public static BudgetSmoothDo getBudgetSmooth(BudgetDo budget, boolean isHour, Long type) {
        BudgetSmoothDo ret = null;


        if (budget != null) {
            ret = new BudgetSmoothDo();
            Double timeRatio = null;
            Double budgetRatio = null;
            if (isHour) {
                timeRatio = getTimeRatio(budget.getTime(), budget.getStartTime(), budget.getEndTime());
            } else {
                timeRatio = getTimeRatio(budget.getTime());
            }
            budgetRatio = getBudgetRatio(budget.getBudget(), budget.getConsumeTotal());


            Double ratio = getRatio(budgetRatio, timeRatio);
            ret.setBudgetDo(budget);
            ret.setBudgetRatio(budgetRatio);
            ret.setTimeRatio(timeRatio);
            ret.setType(type);


            if (!isDelay(budget.getTime())) {
                ret.setRatio(ratio);
            }
        }


        System.out.println(JSON.toJSONString(ret));
        return ret;
    }


    /**

     */
    public static Double getRatio(Double budgetRatio, Double timeRatio) {
        Double ret = null;

        if (budgetRatio != null && timeRatio != null && timeRatio > 0 && budgetRatio > 0) {
            ret = DataUtil.division(budgetRatio, timeRatio, 5);
        }
        return ret;
    }

    /**
     * @return 预算速度
     */
    public static Double getBudgetRatio(Long budget, Long consumeTotal) {
        Double ret = null;
        if (budget != null && consumeTotal != null && budget > 10) {

            Long consume = Math.max(1, consumeTotal);
            ret = DataUtil.division(consume, budget, 5);
            ret = Math.min(ret, 1.0);
        }
        return ret;
    }

    /**
     * @param updateTime
     * @return 时间速度
     */
    public static Double getTimeRatio(String updateTime, String startHour, String endHour) {
        Double ret = null;
        if (updateTime != null) {
            Date updateDate = DateUtil.getDate(updateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);

            String updateHour = DateUtil.getTimeString(updateDate, DateStyle.HH_MM);

            Integer totalMinutes = DateUtil.getIntervalMinutes(startHour, endHour, DateStyle.HH_MM);
            Integer usedMinutes = DateUtil.getIntervalMinutes(startHour, updateHour, DateStyle.HH_MM);

            if (totalMinutes != null && usedMinutes != null && totalMinutes >= 30) {
                ret = (usedMinutes + 1.0) / (totalMinutes + 1.0);
            }

        }
        return DataUtil.formatDouble(ret, 5);
    }

    /**
     * @param updateTime
     * @return 时间速度
     */
    public static boolean isDelay(String updateTime) {
        boolean ret = true;
        if (updateTime != null) {
            String currentTime = DateUtil.getCurrentTime(DateStyle.YYYY_MM_DD_HH_MM_SS);
            Integer delayMinutes = DateUtil.getIntervalMinutes(updateTime, currentTime, DateStyle.YYYY_MM_DD_HH_MM_SS);

            Integer updateHour = DateUtil.getHour(updateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
            Integer currentHour = DateUtil.getHour(currentTime, DateStyle.YYYY_MM_DD_HH_MM_SS);

            if (delayMinutes != null && updateHour != null && currentHour != null && delayMinutes <= 2 && updateHour == currentHour) {
                ret = false;
            }


        }
        return ret;
    }

    /**
     * @param updateTime
     * @return 时间速度
     */
    public static Double getTimeRatio(String updateTime) {
        Double ret = null;
        if (updateTime != null) {
            Integer hour = DateUtil.getHour(updateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);
            Integer minute = DateUtil.getMinute(updateTime, DateStyle.YYYY_MM_DD_HH_MM_SS);

            if (hour != null && minute != null) {
                double ratio1 = reqDist[hour];
                double ratio2 = (reqDist[hour + 1] - reqDist[hour]) * (minute + 1.0) / (60 + 1);
                ret = (ratio1 + ratio2) / 100;
            }


        }
        return DataUtil.formatDouble(ret, 5);
    }

    public static void main(String[] args) {
        BudgetInfo budget = new BudgetInfo();

        BudgetDo acc = new BudgetDo();
        acc.setBudget(10000L);
        acc.setConsumeTotal(1000L);
        acc.setPeriodId(null);
        acc.setTime("2018-08-08 10:44:20");

        budget.setAccountBudgetInfo(acc);

        BudgetDo ad = new BudgetDo();
        ad.setBudget(10000L);
        ad.setConsumeTotal(9000L);
        ad.setPeriodId(null);
        ad.setTime("2018-08-08 10:44:20");
        budget.setAdvertBudgetInfo(ad);

        BudgetDo app = new BudgetDo();
        app.setBudget(-1L);
        app.setConsumeTotal(6000L);
        app.setPeriodId(null);
        app.setTime("2018-08-08 10:44:20");
        budget.setOrientationAndAppBudgetInfo(app);

        BudgetDo ap = new BudgetDo();
        ap.setBudget(10000L);
        ap.setConsumeTotal(6000L);
        ap.setPeriodId(null);
        ap.setTime("2018-08-08 10:44:20");
        budget.setOrientationBudgetInfo(ap);


        BudgetDo at = new BudgetDo();
        at.setBudget(8000L);
        at.setConsumeTotal(999L);
        at.setPeriodId(19L);
        at.setTime("2018-08-08 19:44:20");
        at.setStartTime("19:00");
        at.setEndTime("20:00");
        budget.setOrientationAndTimeBudgetInfo(at);
        BudgetSmoothDo ret = getRatio(budget);

        System.out.println("ret = " + JSON.toJSONString(ret));

    }
}
