/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxFlowRateDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowRate {
    private static final Logger logger = LoggerFactory.getLogger(AdxFlowRate.class);

    public static AdxFlowRateDo getAdxFlowRate(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxFlowRateDo ret = new AdxFlowRateDo();
        try {
            Double roiLimit = 0.95;
            Double defaultFlowRate = 0.33;
            Double addStep = 0.1;
            Double cutStep1 = -0.03;
            Double cutStep2 = -0.07;
            Double defaultMinRoi = 1.0;
            Double weightMs = 0.3;
            Double firFlow = defaultFlowRate;
            Double secFlow = defaultFlowRate;
            Double thiFlow = defaultFlowRate;
            ArrayList<Double> scoreList = new ArrayList<Double>();
            ArrayList<Double> roiDiffMsList = new ArrayList<Double>();
            ArrayList<Double> sucRateMsList = new ArrayList<Double>();
            ArrayList<Double> roiDiffDayList = new ArrayList<Double>();
            ArrayList<Double> sucRateDayList = new ArrayList<Double>();
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                AdxFlowRateDo lastFlowRateDo;
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                if (minRoi != null && minRoi > 1.0) {
                    roiLimit = Math.min(DataUtil.division((Double)1.3, (Double)minRoi), 0.95);
                }
                if (AssertUtil.isNotEmpty((Object)(lastFlowRateDo = adxRoiControlDoInfo.getAdxFlowRateDo()))) {
                    firFlow = AdxStatData.nullToDefault(lastFlowRateDo.getFirFlowRate(), defaultFlowRate);
                    secFlow = AdxStatData.nullToDefault(lastFlowRateDo.getSecFlowRate(), defaultFlowRate);
                    thiFlow = AdxStatData.nullToDefault(lastFlowRateDo.getThiFlowRate(), defaultFlowRate);
                }
                HashMap<String, Double> lastFlowRate = new HashMap<String, Double>();
                lastFlowRate.put(AdxStrategy.ADX_STRATEGY_FIR.getCode(), firFlow);
                lastFlowRate.put(AdxStrategy.ADX_STRATEGY_SEC.getCode(), secFlow);
                lastFlowRate.put(AdxStrategy.ADX_STRATEGY_THI.getCode(), thiFlow);
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                for (AdxStrategy strategy : AdxStrategy.values()) {
                    Map<String, Long> strategyStatMs = AdxStatData.getStrategyStatData(strategy.getCode(), strategyMsDoList);
                    Map<String, Long> strategyStatDay = AdxStatData.getStrategyStatData(strategy.getCode(), strategyDayDoList);
                    Double roiMs = AdxStatData.getRoi(strategyStatMs, minRoi);
                    Double sucRateMs = StrategyBid.getSucRate(strategyStatMs);
                    Double roiDiffMs = StrategyBid.nullToDefault(DataUtil.division((Double)roiMs, (Double)minRoi), (Double)0.0);
                    Double flowRateScoreMs = AdxStatData.getFlowRateScore(strategyStatMs);
                    Double roiDay = AdxStatData.getRoi(strategyStatDay, minRoi);
                    Double sucRateDay = StrategyBid.getSucRate(strategyStatDay);
                    Double roiDiffDay = StrategyBid.nullToDefault(DataUtil.division((Double)roiDay, (Double)minRoi), (Double)0.0);
                    Double flowRateScoreDay = AdxStatData.getFlowRateScore(strategyStatDay);
                    Double flowRateScore = weightMs * flowRateScoreMs + (1.0 - weightMs) * flowRateScoreDay;
                    int ind = DataUtil.toInt((Long)DataUtil.string2Long((String)strategy.getCode()));
                    scoreList.add(ind - 1, DataUtil.formatDouble((Double)flowRateScore, (int)3));
                    roiDiffMsList.add(ind - 1, DataUtil.formatDouble((Double)roiDiffMs, (int)3));
                    sucRateMsList.add(ind - 1, DataUtil.formatDouble((Double)sucRateMs, (int)3));
                    roiDiffDayList.add(ind - 1, DataUtil.formatDouble((Double)roiDiffDay, (int)3));
                    sucRateDayList.add(ind - 1, DataUtil.formatDouble((Double)sucRateDay, (int)3));
                }
                Long ideaBidCntMs = 0L;
                Long ideaAdxConsumeMs = 0L;
                Map<String, Long> ideaMapInfo = adxRoiControlDoInfo.getIdeaIndexMap();
                if (AssertUtil.isNotEmpty(ideaMapInfo)) {
                    ideaBidCntMs = StrategyBid.nullToDefault(ideaMapInfo.get(AdxIndex.BID.getCode()), 0L);
                    ideaAdxConsumeMs = StrategyBid.nullToDefault(ideaMapInfo.get(AdxIndex.ADX_CONSUME.getCode()), 0L);
                }
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || ideaBidCntMs < 200L || ideaAdxConsumeMs < 2000000000L) {
                    firFlow = defaultFlowRate;
                    secFlow = defaultFlowRate;
                    thiFlow = defaultFlowRate;
                } else {
                    Integer maxInd = scoreList.indexOf(Collections.max(scoreList)) + 1;
                    Integer minInd = scoreList.indexOf(Collections.min(scoreList)) + 1;
                    Integer midInd = 6 - maxInd - minInd;
                    if (maxInd != minInd) {
                        Map<String, Double> flowRateAdjust1 = AdxStatData.getFlowRateAdjust(lastFlowRate, maxInd, addStep);
                        Map<String, Double> flowRateAdjust2 = AdxStatData.getFlowRateAdjust(flowRateAdjust1, midInd, cutStep1);
                        Map<String, Double> flowRateAdjust3 = AdxStatData.getFlowRateAdjust(flowRateAdjust2, minInd, cutStep2);
                        firFlow = flowRateAdjust3.get(AdxStrategy.ADX_STRATEGY_FIR.getCode());
                        secFlow = flowRateAdjust3.get(AdxStrategy.ADX_STRATEGY_SEC.getCode());
                        thiFlow = flowRateAdjust3.get(AdxStrategy.ADX_STRATEGY_THI.getCode());
                    }
                }
            }
            Double thiFlowRate = StrategyBid.getNormalValue(thiFlow, defaultFlowRate, 0.1, 0.8);
            Double secFlowRate = StrategyBid.getNormalValue(secFlow, defaultFlowRate, 0.1, 0.9 - thiFlowRate);
            Double firFlowRate = 1.0 - thiFlowRate - secFlowRate;
            ret.setFirFlowRate(DataUtil.formatDouble((Double)firFlowRate, (int)3));
            ret.setSecFlowRate(DataUtil.formatDouble((Double)secFlowRate, (int)3));
            ret.setThiFlowRate(DataUtil.formatDouble((Double)thiFlowRate, (int)3));
            ret.setScoreList(scoreList);
            ret.setRoiDiffMsList(roiDiffMsList);
            ret.setSucRateMsList(sucRateMsList);
            ret.setRoiDiffDayList(roiDiffDayList);
            ret.setSucRateDayList(sucRateDayList);
        }
        catch (Exception e) {
            logger.error("AdxFlowRate.getAdxFlowRate error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            ArrayList<Integer> scoreList1 = new ArrayList<Integer>();
            scoreList1.add(0, 1);
            scoreList1.add(1, 2);
            scoreList1.add(2, 2);
            int maxInd1 = scoreList1.indexOf(Collections.max(scoreList1)) + 1;
            int minInd1 = scoreList1.indexOf(Collections.min(scoreList1)) + 1;
            System.out.println("ret2:" + JSON.toJSONString((Object)maxInd1));
            System.out.println("ret2:" + JSON.toJSONString((Object)minInd1));
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.34,\"roiDiffDayList\":[1.0,1.0,0.926],\"roiDiffMsList\":[1.0,1.0,1.0],\"scoreList\":[0.0,0.0,0.0],\"secFlowRate\":0.331,\"sucRateDayList\":[0.0,0.0,0.0],\"sucRateMsList\":[0.0,0.0,0.0],\"thiFlowRate\":0.331},\"adxRoiFactorDo\":{\"advertConsumeDay\":715.0,\"advertConsumeMs\":715.0,\"adxConsumeDay\":702.02,\"adxConsumeMs\":702.02,\"adxRoiFactor\":0.910005,\"bidCntDay\":57691,\"bidCntMs\":57691,\"lastRealRoi\":1.018497,\"roiDay\":1.018497,\"roiMs\":1.018497,\"sucBidCntDay\":805,\"sucBidCntMs\":805,\"sucDay\":0.013954,\"sucMs\":0.013954},\"basePrice\":900.0,\"defaultPrice\":900,\"factorExplorationDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":4.72,\"adxConsumeMs\":0.0,\"bidCntDay\":0,\"bidCntMs\":0,\"factorExploreMap\":{\"1\":0.96,\"2\":1.0,\"3\":1.040001},\"factorFlowRateMap\":{\"1\":0.201,\"2\":0.601,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.410001,\"2\":1.410001,\"3\":1.410001},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"roiDay\":1.288401,\"roiMs\":1.410001,\"sucBidCntDay\":0,\"sucBidCntMs\":0,\"sucDay\":0.0,\"sucMs\":0.0,\"tryLabel\":2},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":8307,\"advertConsume\":7266,\"adxConsume\":72020020000,\"bid\":174920,\"exp\":7985,\"click\":1606},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":715.0,\"advertConsumeMs\":715.0,\"adxConsumeDay\":702.02,\"adxConsumeMs\":702.02,\"adxRoiFactor\":0.910005,\"bidCntDay\":57691,\"bidCntMs\":57691,\"lastRealRoi\":1.018497,\"roiDay\":1.018497,\"roiMs\":1.018497,\"sucBidCntDay\":805,\"sucBidCntMs\":805,\"sucDay\":0.013954,\"sucMs\":0.013954},\"lastFactorExplorationDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":4.72,\"adxConsumeMs\":0.0,\"bidCntDay\":0,\"bidCntMs\":0,\"factorExploreMap\":{\"1\":0.96,\"2\":1.0,\"3\":1.040001},\"factorFlowRateMap\":{\"1\":0.201,\"2\":0.601,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.410001,\"2\":1.410001,\"3\":1.410001},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"roiDay\":1.288401,\"roiMs\":1.410001,\"sucBidCntDay\":0,\"sucBidCntMs\":0,\"sucDay\":0.0,\"sucMs\":0.0,\"tryLabel\":2},\"lastMinRoi\":1.41,\"lastPriceExplorationDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":0.0,\"adxConsumeMs\":0.0,\"bidCntDay\":0,\"bidCntMs\":0,\"lastRealRoiMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"priceExploreMap\":{\"1\":855.0,\"2\":900.0,\"3\":945.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.6,\"3\":0.201},\"roiDay\":1.410001,\"roiMs\":1.410001,\"sucBidCntDay\":0,\"sucBidCntMs\":0,\"sucDay\":0.0,\"sucMs\":0.0,\"tryLabel\":2},\"maxPrice\":2200,\"minPrice\":100,\"minRoi\":1.41,\"priceExplorationDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":0.0,\"adxConsumeMs\":0.0,\"bidCntDay\":0,\"bidCntMs\":0,\"lastRealRoiMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"priceExploreMap\":{\"1\":855.0,\"2\":900.0,\"3\":945.0},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.6,\"3\":0.201},\"roiDay\":1.410001,\"roiMs\":1.410001,\"sucBidCntDay\":0,\"sucBidCntMs\":0,\"sucDay\":0.0,\"sucMs\":0.0,\"tryLabel\":2},\"resourceIndexMap\":{\"bidSuc\":10319,\"advertConsume\":8815,\"adxConsume\":87567420000,\"bid\":194438,\"exp\":9713,\"click\":1981},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":805,\"advertConsume\":715,\"adxConsume\":7020150000,\"bid\":60871,\"exp\":780,\"click\":151}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":5301,\"advertConsume\":4764,\"adxConsume\":46269000000,\"bid\":37641,\"exp\":5141,\"click\":1065}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":1508,\"advertConsume\":1337,\"adxConsume\":13155150000,\"bid\":10115,\"exp\":1445,\"click\":267}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":56190000,\"bid\":10324,\"exp\":6,\"click\":1}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":769,\"advertConsume\":919,\"adxConsume\":6678000000,\"bid\":37809,\"exp\":742,\"click\":151}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":805,\"advertConsume\":715,\"adxConsume\":7020150000,\"bid\":57691,\"exp\":780,\"click\":151}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":10760,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":5045,\"advertConsume\":4320,\"adxConsume\":43182000000,\"bid\":35622,\"exp\":4798,\"click\":997}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":1508,\"advertConsume\":1312,\"adxConsume\":12864330000,\"bid\":10115,\"exp\":1413,\"click\":266}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":9000000,\"bid\":10268,\"exp\":1,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":769,\"advertConsume\":919,\"adxConsume\":6678000000,\"bid\":35905,\"exp\":742,\"click\":151}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":10659,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastAdxRoiFactorDo()));
            AdxFlowRateDo ret2 = AdxFlowRate.getAdxFlowRate(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

