/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.predict;

import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickAndJoinDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxClickValuePredDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxPredAdDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.MathUtil;
import com.alibaba.fastjson.JSON;
import java.util.List;

public class AdxClickValuePredict {
    public static Double getPredClickValue(AdxClickAndJoinDo mergeAdxClickAndJoinDo, List<AdxPredAdDo> adxPredAdDoList) {
        Double ret = null;
        if (adxPredAdDoList == null) {
            return ret;
        }
        if (adxPredAdDoList.isEmpty()) {
            return 0.0;
        }
        double distictClickRatio = 1.0;
        double[] launchRatio = new double[]{0.7, 0.1, 0.05};
        if (mergeAdxClickAndJoinDo == null || mergeAdxClickAndJoinDo.getClickPv() <= 100L) {
            ret = AdxClickValuePredict.getPredClickValue(distictClickRatio, launchRatio, adxPredAdDoList);
        } else {
            double firstLaunchRatio = MathUtil.division((Long)mergeAdxClickAndJoinDo.getFirstJoinPv(), (Long)mergeAdxClickAndJoinDo.getClickPv(), (int)3);
            double secondLaunchRatio = MathUtil.division((Long)mergeAdxClickAndJoinDo.getSecondJoinPv(), (Long)mergeAdxClickAndJoinDo.getClickPv(), (int)3);
            double thirdLaunchRatio = MathUtil.division((Long)mergeAdxClickAndJoinDo.getThirdJoinPv(), (Long)mergeAdxClickAndJoinDo.getClickPv(), (int)3);
            Double clickAndJoinDiff = AdxClickValuePredict.getClickAndJoinDiff(mergeAdxClickAndJoinDo, adxPredAdDoList);
            firstLaunchRatio = MathUtil.dot((Double)firstLaunchRatio, (Double)(1.0 + clickAndJoinDiff), (int)3);
            launchRatio[0] = Math.min(firstLaunchRatio, 0.99);
            launchRatio[1] = Math.min(secondLaunchRatio, 0.25);
            launchRatio[2] = Math.min(thirdLaunchRatio, 0.1);
            ret = AdxClickValuePredict.getPredClickValue(distictClickRatio, launchRatio, adxPredAdDoList);
        }
        return DataUtil.formatDouble((Double)ret, (int)5);
    }

    private static Double getPredClickValue(double distictClickRatio, double[] launchRatio, List<AdxPredAdDo> adxPredAdDoList) {
        Double ret = null;
        if (AssertUtil.isEmpty(adxPredAdDoList)) {
            return ret;
        }
        System.out.println("distictClickRatio=" + distictClickRatio + ",launchRatio=" + JSON.toJSONString((Object)launchRatio) + ",adxPredAdDoList=" + JSON.toJSONString(adxPredAdDoList));
        int size = Math.min(adxPredAdDoList.size(), 3);
        ret = 0.0;
        for (int i = 0; i < size; ++i) {
            AdxPredAdDo adxPredAdDo = adxPredAdDoList.get(i);
            ret = ret + MathUtil.dot((Double)adxPredAdDo.getArpu(), (Double)launchRatio[i], (int)5);
        }
        return ret;
    }

    public static AdxClickAndJoinDo getMergeStatClickValue(AdxClickValuePredDo adxClickValuePredDo) {
        AdxClickAndJoinDo ret = null;
        if (adxClickValuePredDo != null) {
            AdxClickAndJoinDo ideaAdxClickAndJoinDo = AdxClickValuePredict.statMerge(adxClickValuePredDo.getIdeaLastNHoursDoList());
            AdxClickAndJoinDo resourceAdxClickAndJoinDo = AdxClickValuePredict.statMerge(adxClickValuePredDo.getResourceLastNHoursDoList());
            ret = AdxClickValuePredict.statMerge(ideaAdxClickAndJoinDo, resourceAdxClickAndJoinDo);
        }
        return ret;
    }

    public static AdxClickAndJoinDo statMerge(AdxClickAndJoinDo ideaAdxClickAndJoinDo, AdxClickAndJoinDo resourceAdxClickAndJoinDo) {
        AdxClickAndJoinDo ret = null;
        if (AssertUtil.isAllEmpty((Object[])new Object[]{ideaAdxClickAndJoinDo, resourceAdxClickAndJoinDo})) {
            return ret;
        }
        if (ideaAdxClickAndJoinDo == null) {
            return resourceAdxClickAndJoinDo;
        }
        if (resourceAdxClickAndJoinDo == null) {
            return ideaAdxClickAndJoinDo;
        }
        ret = new AdxClickAndJoinDo();
        Double resourceWeight = 1.0;
        if (resourceAdxClickAndJoinDo.getClickPv() > 1000L) {
            resourceWeight = MathUtil.division((Long)1000L, (Long)resourceAdxClickAndJoinDo.getClickPv(), (int)4);
        }
        Long clickPv = MathUtil.dot((Long)ideaAdxClickAndJoinDo.getClickPv(), (Double)1.0) + MathUtil.dot((Long)resourceAdxClickAndJoinDo.getClickPv(), (Double)resourceWeight);
        Long distictClickPv = MathUtil.dot((Long)ideaAdxClickAndJoinDo.getDistictClickPv(), (Double)1.0) + MathUtil.dot((Long)resourceAdxClickAndJoinDo.getDistictClickPv(), (Double)resourceWeight);
        Long firstJoinPv = MathUtil.dot((Long)ideaAdxClickAndJoinDo.getFirstJoinPv(), (Double)1.0) + MathUtil.dot((Long)resourceAdxClickAndJoinDo.getFirstJoinPv(), (Double)resourceWeight);
        Long secondJoinPv = MathUtil.dot((Long)ideaAdxClickAndJoinDo.getSecondJoinPv(), (Double)1.0) + MathUtil.dot((Long)resourceAdxClickAndJoinDo.getSecondJoinPv(), (Double)resourceWeight);
        Long thirdJoinPv = MathUtil.dot((Long)ideaAdxClickAndJoinDo.getThirdJoinPv(), (Double)1.0) + MathUtil.dot((Long)resourceAdxClickAndJoinDo.getThirdJoinPv(), (Double)resourceWeight);
        ret.setClickPv(clickPv);
        ret.setDistictClickPv(distictClickPv);
        ret.setFirstJoinPv(firstJoinPv);
        ret.setSecondJoinPv(secondJoinPv);
        ret.setThirdJoinPv(thirdJoinPv);
        Long ideaId = ideaAdxClickAndJoinDo.getIdeaId();
        if (AssertUtil.isNotEmpty((Object)ideaId)) {
            ret.setIdeaId(ideaId);
        }
        return ret;
    }

    private static AdxClickAndJoinDo statMerge(List<AdxClickAndJoinDo> adxClickAndJoinDoList) {
        AdxClickAndJoinDo ret = null;
        if (AssertUtil.isEmpty(adxClickAndJoinDoList)) {
            return ret;
        }
        ret = new AdxClickAndJoinDo();
        int size = Math.min(adxClickAndJoinDoList.size(), 6);
        Long ideaId = null;
        Long clickPv = 0L;
        Long distictClickPv = 0L;
        Long firstJoinPv = 0L;
        Long secondJoinPv = 0L;
        Long thirdJoinPv = 0L;
        for (int i = 0; i < size; ++i) {
            AdxClickAndJoinDo adxClickAndJoinDo = adxClickAndJoinDoList.get(i);
            if (AssertUtil.isEmpty(ideaId) && AssertUtil.isNotEmpty((Object)adxClickAndJoinDo)) {
                ideaId = adxClickAndJoinDo.getIdeaId();
            }
            Double weight = 1.0 - (double)i * 0.1;
            clickPv = clickPv + MathUtil.dot((Long)adxClickAndJoinDo.getClickPv(), (Double)weight);
            distictClickPv = distictClickPv + MathUtil.dot((Long)adxClickAndJoinDo.getDistictClickPv(), (Double)weight);
            firstJoinPv = firstJoinPv + MathUtil.dot((Long)adxClickAndJoinDo.getFirstJoinPv(), (Double)weight);
            secondJoinPv = secondJoinPv + MathUtil.dot((Long)adxClickAndJoinDo.getSecondJoinPv(), (Double)weight);
            thirdJoinPv = thirdJoinPv + MathUtil.dot((Long)adxClickAndJoinDo.getThirdJoinPv(), (Double)weight);
        }
        firstJoinPv = firstJoinPv + secondJoinPv + thirdJoinPv;
        secondJoinPv = secondJoinPv + thirdJoinPv;
        ret.setClickPv(clickPv);
        ret.setDistictClickPv(distictClickPv);
        ret.setFirstJoinPv(firstJoinPv);
        ret.setSecondJoinPv(secondJoinPv);
        ret.setThirdJoinPv(thirdJoinPv);
        ret.setIdeaId(ideaId);
        return ret;
    }

    private static Double getClickAndJoinDiff(AdxClickAndJoinDo mergeAdxClickAndJoinDo, List<AdxPredAdDo> adxPredAdDoList) {
        Double ret = 0.0;
        if (AssertUtil.isAllNotEmpty((Object[])new Object[]{mergeAdxClickAndJoinDo, adxPredAdDoList})) {
            AdxPredAdDo adxPredAdDo = adxPredAdDoList.get(0);
            Double firstArpu = adxPredAdDo.getArpu();
            Long ideaId = mergeAdxClickAndJoinDo.getIdeaId();
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{ideaId, firstArpu})) {
                if (ideaId == 3303L) {
                    ret = 0.013 * Math.pow(firstArpu, 2.0) - 0.23 * firstArpu + 0.96;
                } else if (ideaId == 4690L) {
                    ret = 0.014 * Math.pow(firstArpu, 2.0) - 0.2 * firstArpu + 0.58;
                }
            }
        }
        return StrategyBid.getNormalValue(ret, 0.0, -0.3, 0.3);
    }
}

