/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.cpcautobidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingInfo;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingParams;
import cn.com.duiba.nezha.alg.alg.cpcautobidding.CpcAutoBiddingResult;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpcAutoBidding {
    private static final Logger logger = LoggerFactory.getLogger(CpcAutoBidding.class);

    public static CpcAutoBiddingResult cpcAutoBiddingFactor(CpcAutoBiddingInfo cpcAutoBiddingInfo, Double lastCpcAutoBiddingFactor, CpcAutoBiddingParams cpcAutoBiddingParams) {
        CpcAutoBiddingResult ret = new CpcAutoBiddingResult();
        if (AssertUtil.isEmpty((Object)cpcAutoBiddingInfo)) {
            return ret;
        }
        if (Math.random() < 1.0E-4) {
            logger.info("params cpcAutoBiddingParams:{}", (Object)cpcAutoBiddingParams);
        }
        try {
            ret = CpcAutoBidding.getRankScroreRatio(cpcAutoBiddingInfo);
        }
        catch (Exception e) {
            logger.warn("getRankScroreRatio happend error,cpcAutoBiddingInfo={}", (Object)JSON.toJSONString((Object)cpcAutoBiddingInfo), (Object)e);
        }
        if (lastCpcAutoBiddingFactor != null && lastCpcAutoBiddingFactor != 0.0) {
            ret.setCpcAutoBiddingFactor(lastCpcAutoBiddingFactor);
        }
        if (cpcAutoBiddingInfo.autoBiddingType != null && cpcAutoBiddingInfo.autoBiddingType == 1) {
            CpcAutoBidding.updateFactor1(ret, cpcAutoBiddingParams);
        }
        if (cpcAutoBiddingInfo.autoBiddingType != null && cpcAutoBiddingInfo.autoBiddingType == 2) {
            CpcAutoBidding.updateFactor2(ret, cpcAutoBiddingParams);
        }
        if (Math.random() < 0.001) {
            logger.info("cpcAutoBidding cpcAutoBiddingFactor:{}", (Object)ret);
        }
        return ret;
    }

    public static CpcAutoBiddingResult getRankScroreRatio(CpcAutoBiddingInfo cpcAutoBiddingInfo) {
        CpcAutoBiddingResult ret = new CpcAutoBiddingResult();
        Double rankScoreRatio = 0.01;
        Double costConvert = 1.0;
        Double orientCostConvertToday = cpcAutoBiddingInfo.orientConvertToday != 0L ? (double)cpcAutoBiddingInfo.orientCostToday.longValue() / (double)cpcAutoBiddingInfo.orientConvertToday.longValue() : (double)cpcAutoBiddingInfo.orientCostToday.longValue();
        Double orientCostConvertBias = cpcAutoBiddingInfo.target != 0L ? orientCostConvertToday / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientCostConvertHour = cpcAutoBiddingInfo.orientConvertHour != 0L ? (double)cpcAutoBiddingInfo.orientCostHour.longValue() / (double)cpcAutoBiddingInfo.orientConvertHour.longValue() : (double)cpcAutoBiddingInfo.orientCostHour.longValue();
        Double orientCostConvertHourBias = cpcAutoBiddingInfo.target != 0L ? orientCostConvertHour / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientAppCostConvertToday = cpcAutoBiddingInfo.orientAppConvertToday != 0L ? (double)cpcAutoBiddingInfo.orientAppCostToday.longValue() / (double)cpcAutoBiddingInfo.orientAppConvertToday.longValue() : (double)cpcAutoBiddingInfo.orientAppCostToday.longValue();
        Double orientAppCostConvertBias = cpcAutoBiddingInfo.target != 0L ? orientAppCostConvertToday / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientAppCostConvertHour = cpcAutoBiddingInfo.orientAppConvertHour != 0L ? (double)cpcAutoBiddingInfo.orientAppCostHour.longValue() / (double)cpcAutoBiddingInfo.orientAppConvertHour.longValue() : (double)cpcAutoBiddingInfo.orientAppCostHour.longValue();
        Double orientAppCostConvertHourBias = cpcAutoBiddingInfo.target != 0L ? orientAppCostConvertHour / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientRankScoreRatio = cpcAutoBiddingInfo.orientRankScore10 != 0.0 ? cpcAutoBiddingInfo.orientRankScore9 / cpcAutoBiddingInfo.orientRankScore10 : 10.0 * cpcAutoBiddingInfo.orientRankScore9;
        Double orientHourRankScoreRatio = cpcAutoBiddingInfo.orientHourRankScore10 != 0.0 ? cpcAutoBiddingInfo.orientHourRankScore9 / cpcAutoBiddingInfo.orientHourRankScore10 : 10.0 * cpcAutoBiddingInfo.orientHourRankScore9;
        Double orientAppRankScoreRatio = cpcAutoBiddingInfo.orientAppRankScore10 != 0.0 ? cpcAutoBiddingInfo.orientAppRankScore9 / cpcAutoBiddingInfo.orientAppRankScore10 : 10.0 * cpcAutoBiddingInfo.orientAppRankScore9;
        Double orientAppHourRankScoreRatio = cpcAutoBiddingInfo.orientAppHourRankScore10 != 0.0 ? cpcAutoBiddingInfo.orientAppHourRankScore9 / cpcAutoBiddingInfo.orientAppHourRankScore10 : 10.0 * cpcAutoBiddingInfo.orientAppHourRankScore9;
        Double orientCostConvert7day = cpcAutoBiddingInfo.orientConvert7day != 0L ? (double)cpcAutoBiddingInfo.orientCost7day.longValue() / (double)cpcAutoBiddingInfo.orientConvert7day.longValue() : (double)cpcAutoBiddingInfo.orientCost7day.longValue();
        Double orientCostConvert7Bias = cpcAutoBiddingInfo.target != 0L ? orientCostConvert7day / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        Double orientAppCostConvert7day = cpcAutoBiddingInfo.orientAppConvert7day != 0L ? (double)cpcAutoBiddingInfo.orientAppCost7day.longValue() / (double)cpcAutoBiddingInfo.orientAppConvert7day.longValue() : (double)cpcAutoBiddingInfo.orientAppCost7day.longValue();
        Double orientAppCostConvert7Bias = cpcAutoBiddingInfo.target != 0L ? orientAppCostConvert7day / (double)cpcAutoBiddingInfo.target.longValue() : 1.0;
        if (cpcAutoBiddingInfo.orientAppBiddingCntToday > 1000L) {
            costConvert = 0.8 * orientAppCostConvertBias + 0.2 * orientCostConvertBias;
            if (cpcAutoBiddingInfo.orientAppBiddingCntHour > 1000L) {
                costConvert = 0.8 * orientAppCostConvertHourBias + 0.2 * orientAppCostConvertBias;
                rankScoreRatio = 0.8 * orientAppHourRankScoreRatio + 0.2 * orientAppRankScoreRatio;
            } else {
                rankScoreRatio = cpcAutoBiddingInfo.orientBiddingCntHour > 1000L ? Double.valueOf(0.8 * orientHourRankScoreRatio + 0.2 * orientAppRankScoreRatio) : orientAppRankScoreRatio;
            }
        } else {
            costConvert = orientCostConvertBias;
            if (cpcAutoBiddingInfo.orientBiddingCntHour > 1000L) {
                costConvert = orientCostConvertHourBias;
                rankScoreRatio = 0.8 * orientHourRankScoreRatio + 0.2 * orientRankScoreRatio;
            } else {
                rankScoreRatio = orientRankScoreRatio;
            }
        }
        if (cpcAutoBiddingInfo.convertType == 6 || cpcAutoBiddingInfo.convertType == 8) {
            costConvert = cpcAutoBiddingInfo.orientAppConvert7day > 40L ? orientAppCostConvert7Bias : orientCostConvert7Bias;
            if (Math.random() < 0.01) {
                logger.info("cpcAutoBidding converttype68:{}", (Object)costConvert);
            }
        }
        ret.setRankScroreRatio(rankScoreRatio);
        ret.setCostConvert(costConvert);
        return ret;
    }

    public static void updateFactor1(CpcAutoBiddingResult cpcAutoBiddingResult, CpcAutoBiddingParams cpcAutoBiddingParams) {
        Double totalFactor;
        Double totalFactor1;
        Double ret = 1.0;
        Double totalLearnRate = cpcAutoBiddingParams.totalLearnRate1;
        Double factorLowerLimit = cpcAutoBiddingParams.fatorLowerLimit1;
        Double factorUpperLimit = cpcAutoBiddingParams.fatorUpperLimit1;
        Double rankScroreRatioLimit = cpcAutoBiddingParams.rankScroreRatioLimit1;
        Double costConvertLimit = cpcAutoBiddingParams.costConvertLimit;
        if (cpcAutoBiddingResult == null) {
            return;
        }
        Double cpcAutoBiddingFactor = cpcAutoBiddingResult.getCpcAutoBiddingFactor();
        if (cpcAutoBiddingFactor == null) {
            cpcAutoBiddingFactor = 1.0;
        }
        Double rankScroreRatio = cpcAutoBiddingResult.rankScroreRatio;
        Double costConvert = cpcAutoBiddingResult.costConvert;
        if (costConvert > 0.0 && costConvert < 1.15 && rankScroreRatio >= rankScroreRatioLimit || costConvert > 0.0 && costConvert < costConvertLimit) {
            totalFactor1 = MathBase.noiseSmoother(rankScroreRatio / (costConvert * costConvert), 0.15, 0.4);
            totalFactor = totalLearnRate + totalFactor1;
            ret = cpcAutoBiddingFactor * totalFactor;
            ret = MathBase.noiseSmoother(ret, factorLowerLimit, factorUpperLimit);
        }
        if (rankScroreRatio > 0.0 && rankScroreRatio < rankScroreRatioLimit && costConvert > 0.0 && costConvert > costConvertLimit) {
            totalFactor1 = MathBase.noiseSmoother(rankScroreRatio / (costConvert * costConvert), 0.08, 0.15);
            totalFactor = totalLearnRate + totalFactor1;
            ret = cpcAutoBiddingFactor * totalFactor;
            if (costConvert > 1.3) {
                ret = 1.0;
            }
            ret = MathBase.noiseSmoother(ret, 1.0, 1.05);
        }
        ret = DataUtil.formatDouble((Double)ret, (int)4);
        cpcAutoBiddingResult.setCpcAutoBiddingFactor(ret);
    }

    public static void updateFactor2(CpcAutoBiddingResult cpcAutoBiddingResult, CpcAutoBiddingParams cpcAutoBiddingParams) {
        Double totalFactor;
        Double totalFactor1;
        Double rankScroreRatio;
        Double ret = 1.0;
        Double totalLearnRate = cpcAutoBiddingParams.totalLearnRate2;
        Double factorLowerLimit = cpcAutoBiddingParams.fatorLowerLimit2;
        Double factorUpperLimit = cpcAutoBiddingParams.fatorUpperLimit2;
        Double rankScroreRatioLimit = cpcAutoBiddingParams.rankScroreRatioLimit2;
        if (cpcAutoBiddingResult == null) {
            return;
        }
        Double cpcAutoBiddingFactor = cpcAutoBiddingResult.getCpcAutoBiddingFactor();
        if (cpcAutoBiddingFactor == null) {
            cpcAutoBiddingFactor = 1.0;
        }
        if ((rankScroreRatio = cpcAutoBiddingResult.rankScroreRatio) >= rankScroreRatioLimit) {
            totalFactor1 = MathBase.noiseSmoother(rankScroreRatio, 0.15, 0.4);
            totalFactor = totalLearnRate + totalFactor1;
            ret = cpcAutoBiddingFactor * totalFactor;
            ret = MathBase.noiseSmoother(ret, factorLowerLimit, factorUpperLimit);
        }
        if (rankScroreRatio > 0.0 && rankScroreRatio < rankScroreRatioLimit) {
            totalFactor1 = MathBase.noiseSmoother(rankScroreRatio, 0.08, 0.15);
            totalFactor = totalLearnRate + totalFactor1;
            ret = cpcAutoBiddingFactor * totalFactor;
            ret = MathBase.noiseSmoother(ret, 1.0, 1.05);
        }
        ret = DataUtil.formatDouble((Double)ret, (int)4);
        cpcAutoBiddingResult.setCpcAutoBiddingFactor(ret);
    }
}

