/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.bidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.AutoBiddingDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoBidding {
    private static final Logger logger = LoggerFactory.getLogger(AutoBidding.class);
    static double[] ratioBucket = new double[]{0.05, 0.1, 0.3, 0.5, 0.7, 1.0};
    static double[] ratioWeight = new double[]{1.0, 0.95, 0.9, 0.85, 0.8, 0.75};
    static double weight = 0.8;

    public static AutoBiddingDo getFactor(AutoBiddingDo autoBiddingDo) {
        if (autoBiddingDo != null) {
            autoBiddingDo.setAppAfeeFactor(1.0);
        }
        if (!AutoBidding.valid(autoBiddingDo)) {
            logger.error("AutoBidding.getFactor(AutoBiddingDo autoBiddingDo)  input invalid ,autoBiddingDo=" + JSON.toJSONString((Object)autoBiddingDo));
            return autoBiddingDo;
        }
        Double factor = AutoBidding.getAppFactor(autoBiddingDo);
        autoBiddingDo.setAppAfeeFactor(factor);
        return autoBiddingDo;
    }

    private static Double getAppFactor(AutoBiddingDo autoBiddingDo) {
        Double ret = 1.0;
        Double appBasePvRatioWeight = 1.0;
        if (autoBiddingDo.getAdAndappBasePv() != null) {
            Double appBasePvRatio = DataUtil.division((Long)autoBiddingDo.getAdAndappBasePv(), (Long)autoBiddingDo.getAdBasePv(), (int)3);
            appBasePvRatio = MathBase.noiseSmoother(appBasePvRatio, 0.001, 0.9);
            appBasePvRatioWeight = MathBase.getConfidenceWeight(appBasePvRatio, ratioBucket, ratioWeight);
            System.out.println("appBasePvRatio=" + appBasePvRatio);
            System.out.println("appBasePvRatioWeight=" + appBasePvRatioWeight);
        }
        Double appBcvrRatioWeight = 1.0;
        if (autoBiddingDo.getAdAndappBCvr() != null) {
            Double appBcvrRatio = DataUtil.division((Double)autoBiddingDo.getAdAndappBCvr(), (Double)autoBiddingDo.getAdBCvr(), (int)3);
            appBcvrRatio = MathBase.noiseSmoother(appBcvrRatio, 0.4, 2.0);
            appBcvrRatioWeight = 1.0 - weight + weight * appBcvrRatio;
            System.out.println("appBcvrRatioWeight=" + appBcvrRatioWeight);
        }
        if (appBasePvRatioWeight != null && appBcvrRatioWeight != null) {
            ret = 1.0 + (appBcvrRatioWeight - 1.0) * appBasePvRatioWeight;
        }
        return ret;
    }

    private static boolean valid(AutoBiddingDo autoBiddingDo) {
        if (autoBiddingDo == null) {
            return false;
        }
        if (autoBiddingDo.getBaseType() == null || autoBiddingDo.getSecondSubType() == null) {
            return false;
        }
        if (autoBiddingDo.getAdBasePv() == null) {
            return false;
        }
        return autoBiddingDo.getAdBCvr() != null;
    }
}

