package cn.com.duiba.nezha.alg.alg.bidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.AutoBiddingDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

public class AutoBidding {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(AutoBidding.class);

    /**
     * 媒体转化占比调节因子
     */
    static double[] ratioBucket = {0.05, 0.1, 0.3, 0.5, 0.7, 1.0};
    static double[] ratioWeight = {1, 0.95, 0.90, 0.85, 0.8, 0.75};

    /**
     * 媒体转化率调节因子
     */
    static double weight = 0.8;


    /**
     * OCPA-分媒体自动目标转化出价
     *
     * @param autoBiddingDo
     * @return
     */
    public static AutoBiddingDo getFactor(AutoBiddingDo autoBiddingDo) {

        // 初始化默认值
        if (autoBiddingDo != null) {
            autoBiddingDo.setAppAfeeFactor(1.0);
        }

        //判断输入是否合法
        if (!valid(autoBiddingDo)) {
            logger.error("AutoBidding.getFactor(AutoBiddingDo autoBiddingDo)  input invalid ,autoBiddingDo=" + JSON.toJSONString(autoBiddingDo));
            return autoBiddingDo;
        }

        // 计算调节因子
        Double factor = getAppFactor(autoBiddingDo);

        // 更新调节因子
        autoBiddingDo.setAppAfeeFactor(factor);

        // 返回
        return autoBiddingDo;

    }

    private static Double getAppFactor(AutoBiddingDo autoBiddingDo) {
        Double ret = 1.0;

        // 媒体转化占比

        Double appBasePvRatioWeight = 1.0;
        if (autoBiddingDo.getAdAndappBasePv() != null) {
            Double appBasePvRatio = DataUtil.division(autoBiddingDo.getAdAndappBasePv(), autoBiddingDo.getAdBasePv(), 3);
            appBasePvRatio = MathBase.noiseSmoother(appBasePvRatio, 0.001, 0.9);

            appBasePvRatioWeight = MathBase.getConfidenceWeight(appBasePvRatio, ratioBucket, ratioWeight);
            System.out.println("appBasePvRatio="+appBasePvRatio);
            System.out.println("appBasePvRatioWeight="+appBasePvRatioWeight);
        }


        // 媒体转化率比例
        Double appBcvrRatioWeight = 1.0;
        if (autoBiddingDo.getAdAndappBCvr() != null) {
            Double appBcvrRatio = DataUtil.division(autoBiddingDo.getAdAndappBCvr(), autoBiddingDo.getAdBCvr(), 3);
            appBcvrRatio = MathBase.noiseSmoother(appBcvrRatio, 0.4, 2.0);
            appBcvrRatioWeight = (1 - weight) + weight * appBcvrRatio;
            System.out.println("appBcvrRatioWeight="+appBcvrRatioWeight);
        }

        // 调节因子
        if (appBasePvRatioWeight != null && appBcvrRatioWeight != null) {

            ret = 1  + (appBcvrRatioWeight-1)*appBasePvRatioWeight;
        }

        return ret;
    }

    private static boolean valid(AutoBiddingDo autoBiddingDo) {

        if (autoBiddingDo == null) {
            return false;
        }


        if (autoBiddingDo.getBaseType() == null || autoBiddingDo.getSecondSubType() == null) {
            return false;
        }
        if (autoBiddingDo.getAdBasePv() == null) {
            return false;
        }
        if (autoBiddingDo.getAdBCvr() == null) {
            return false;
        }

        return true;

    }
}
