/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import com.alibaba.fastjson.JSON;

public class AdxBidding {
    public static Long getAdxParPrice(AdxDo adxDoInfo, Double adxBiddingRoiFactor) {
        Double defaultPreCtr = 0.07;
        Double defaultStatClickValue = 10.0;
        Double defaultMinRoi = 1.0;
        Double defaultRoiFactor = 1.0;
        Double roiFactorLowerLimit = 0.8;
        Double roiFactorUpperLimit = 1.3;
        if (adxBiddingRoiFactor == null || adxBiddingRoiFactor < roiFactorLowerLimit || adxBiddingRoiFactor > roiFactorUpperLimit) {
            adxBiddingRoiFactor = defaultRoiFactor;
        }
        Long parPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000.0 / (defaultMinRoi * adxBiddingRoiFactor)));
        if (AssertUtil.isNotEmpty((Object)adxDoInfo)) {
            Double currentPreValue = adxDoInfo.getCurrentPreValue();
            Double statCtr = adxDoInfo.getStatCtr();
            Double statClickValue = adxDoInfo.getStatClickValue();
            Double minRoi = adxDoInfo.getMinRoi();
            Double preCtr = AdxBidding.getPreCTR(currentPreValue, statCtr);
            if (preCtr == null || preCtr <= 0.0 || preCtr >= 1.0) {
                preCtr = defaultPreCtr;
            }
            if (statClickValue == null || statClickValue <= 0.0) {
                statClickValue = defaultStatClickValue;
            }
            if (minRoi == null || minRoi < 1.0) {
                minRoi = defaultMinRoi;
            }
            parPrice = Math.round(Math.floor(preCtr * statClickValue * 1000.0 / (minRoi * adxBiddingRoiFactor)));
        }
        return parPrice;
    }

    public static Double getPreCTR(Double modelPreValue, Double statValue) {
        Double ret = 0.07;
        Double preCtrFactor = 0.0;
        Double vUpperLimit = 0.9999;
        Double vLowerLimit = 0.0;
        Double fUpperLimit = 3.0;
        Double fLowerLimit = 0.2;
        if (statValue == null || statValue < vLowerLimit || statValue > vUpperLimit) {
            statValue = ret;
        }
        ret = modelPreValue == null || modelPreValue < vLowerLimit || modelPreValue > vUpperLimit ? statValue : (modelPreValue / statValue > fLowerLimit && modelPreValue / statValue < fUpperLimit ? Double.valueOf(preCtrFactor * modelPreValue + (1.0 - preCtrFactor) * statValue) : statValue);
        return ret;
    }

    public static void main(String[] args) {
        try {
            AdxDo adxDoInfo = new AdxDo();
            adxDoInfo.setCurrentPreValue(null);
            adxDoInfo.setStatCtr(0.0);
            adxDoInfo.setStatClickValue(0.0);
            adxDoInfo.setMinRoi(0.0);
            Double roiFactor = 0.0;
            Long testParPrice = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor);
            System.out.println("testGetAdxParPrice:" + JSON.toJSONString((Object)testParPrice));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

