/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;

public class AdxRoiFactor {
    public static String[] adxPricelevel = new String[]{"1", "2", "3", "4", "5"};

    public static Map<String, Double> getAdxRoiFactor(Double minRoi, AdxRoiControlDo adxRoiControlDoInfo, Map<String, Double> lastAdxRoiFactor) {
        int i;
        Double defaultMinRoi = 1.0;
        Double defaultRoiFactor = 1.0;
        Double roiFactorLowerLimit = 0.8;
        Double roiFactorUpperLimit = 1.3;
        Double compareRate = 0.05;
        if (lastAdxRoiFactor == null) {
            lastAdxRoiFactor = new HashMap<String, Double>();
            for (i = 0; i < adxPricelevel.length; ++i) {
                lastAdxRoiFactor.put(adxPricelevel[i], defaultRoiFactor);
            }
        } else {
            for (i = 0; i < adxPricelevel.length; ++i) {
                if (lastAdxRoiFactor.get(adxPricelevel[i]) != null && !(lastAdxRoiFactor.get(adxPricelevel[i]) < roiFactorLowerLimit) && !(lastAdxRoiFactor.get(adxPricelevel[i]) > roiFactorUpperLimit)) continue;
                lastAdxRoiFactor.put(adxPricelevel[i], defaultRoiFactor);
            }
        }
        if (minRoi == null || minRoi < 1.0) {
            minRoi = defaultMinRoi;
        }
        Map<String, Double> adxRoiFactor = lastAdxRoiFactor;
        if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
            Long defaultFee = 0L;
            Long expStatAllDayAdxFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getExpStatAllDayAdxFee(), defaultFee);
            Long expStatAllDayAdvertFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getExpStatAllDayAdvertFee(), defaultFee);
            Long comStatAllDayAdxFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getComStatAllDayAdxFee(), defaultFee);
            Long comStatAllDayAdvertFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getComStatAllDayAdvertFee(), defaultFee);
            Map<String, Long> expStatBucketDayAdxFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getExpStatBucketDayAdxFee(), defaultFee);
            Map<String, Long> expStatBucketDayAdvertFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getExpStatBucketDayAdvertFee(), defaultFee);
            Map<String, Long> comStatBucketDayAdxFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getComStatBucketDayAdxFee(), defaultFee);
            Map<String, Long> comStatBucketDayAdvertFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getComStatBucketDayAdvertFee(), defaultFee);
            Map<String, Long> expStatBucketAdxFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getExpStatBucketAdxFee(), defaultFee);
            Map<String, Long> expStatBucketAdvertFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getExpStatBucketAdvertFee(), defaultFee);
            Map<String, Long> comStatBucketAdxFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getComStatBucketAdxFee(), defaultFee);
            Map<String, Long> comStatBucketAdvertFee = AdxRoiFactor.nullToDefaultValue(adxRoiControlDoInfo.getComStatBucketAdvertFee(), defaultFee);
            Double expAllDayRoi = DataUtil.division((Long)expStatAllDayAdvertFee, (Long)expStatAllDayAdxFee, (int)2);
            Double comAllDayRoi = DataUtil.division((Long)comStatAllDayAdvertFee, (Long)comStatAllDayAdxFee, (int)2);
            Map<String, Double> expStatBucketRoi = AdxRoiFactor.calculateMap(expStatBucketAdxFee, expStatBucketAdvertFee);
            Map<String, Double> comStatBucketRoi = AdxRoiFactor.calculateMap(comStatBucketAdxFee, comStatBucketAdvertFee);
            System.out.println("expAllDayRoi:" + JSON.toJSONString((Object)expAllDayRoi));
            System.out.println("comAllDayRoi:" + JSON.toJSONString((Object)comAllDayRoi));
            System.out.println("expStatBucketRoi:" + JSON.toJSONString(expStatBucketRoi));
            System.out.println("comStatBucketRoi:" + JSON.toJSONString(comStatBucketRoi));
            Double alpha = 0.8;
            Double step = 0.05;
            for (Map.Entry<String, Double> entry : lastAdxRoiFactor.entrySet()) {
                String adxPriceLevel = entry.getKey();
                Double lastRoiFactor = entry.getValue();
                Double roiFactor = lastRoiFactor;
                if (roiFactor == null) {
                    roiFactor = defaultRoiFactor;
                } else {
                    if (adxPriceLevel.equals("1") && (expAllDayRoi > minRoi * 0.9 || expAllDayRoi > comAllDayRoi * 1.1 || expStatBucketRoi.get(adxPriceLevel) > minRoi * 0.85 || expStatBucketRoi.get(adxPriceLevel) > comStatBucketRoi.get(adxPriceLevel) * 1.05) && ((double)expStatAllDayAdxFee.longValue() < (double)comStatAllDayAdxFee.longValue() * (1.0 / compareRate - 1.0) * 0.9 || (double)expStatBucketDayAdxFee.get(adxPriceLevel).longValue() < (double)comStatBucketDayAdxFee.get(adxPriceLevel).longValue() * (1.0 / compareRate - 1.0) * 0.85)) {
                        roiFactor = roiFactor + -alpha.doubleValue() * step;
                    }
                    if (adxPriceLevel.equals("2") && (expAllDayRoi > minRoi * 0.95 || expAllDayRoi > comAllDayRoi * 1.1 || expStatBucketRoi.get(adxPriceLevel) > minRoi * 0.9 || expStatBucketRoi.get(adxPriceLevel) > comStatBucketRoi.get(adxPriceLevel) * 1.05) && ((double)expStatAllDayAdxFee.longValue() < (double)comStatAllDayAdxFee.longValue() * (1.0 / compareRate - 1.0) * 0.95 || (double)expStatBucketDayAdxFee.get(adxPriceLevel).longValue() < (double)comStatBucketDayAdxFee.get(adxPriceLevel).longValue() * (1.0 / compareRate - 1.0) * 0.9)) {
                        roiFactor = roiFactor + -alpha.doubleValue() * step;
                    }
                    if (adxPriceLevel.equals("3") && (expAllDayRoi < minRoi * 0.85 || expAllDayRoi < comAllDayRoi * 1.05 || expStatBucketRoi.get(adxPriceLevel) < minRoi * 0.85 || expStatBucketRoi.get(adxPriceLevel) < comStatBucketRoi.get(adxPriceLevel) * 1.07)) {
                        roiFactor = roiFactor + alpha * step;
                    }
                    if (adxPriceLevel.equals("4") && (expAllDayRoi < minRoi * 0.9 || expAllDayRoi < comAllDayRoi * 1.07 || expStatBucketRoi.get(adxPriceLevel) < minRoi * 0.9 || expStatBucketRoi.get(adxPriceLevel) < comStatBucketRoi.get(adxPriceLevel) * 1.1)) {
                        roiFactor = roiFactor + alpha * step;
                    }
                    if (adxPriceLevel.equals("5") && (expAllDayRoi < minRoi * 0.95 || expAllDayRoi < comAllDayRoi * 1.1 || expStatBucketRoi.get(adxPriceLevel) < minRoi * 0.95 || expStatBucketRoi.get(adxPriceLevel) < comStatBucketRoi.get(adxPriceLevel) * 1.13)) {
                        roiFactor = roiFactor + alpha * step;
                    }
                }
                adxRoiFactor.put(adxPriceLevel, roiFactor);
            }
        }
        return adxRoiFactor;
    }

    public static Map<String, Double> calculateMap(Map<String, Long> adxFeeMap, Map<String, Long> advertFeeMap) {
        HashMap<String, Double> retMap = new HashMap<String, Double>();
        for (Map.Entry<String, Long> entry : adxFeeMap.entrySet()) {
            String key = entry.getKey();
            Long adx = entry.getValue();
            Long advert = advertFeeMap.get(key);
            Double roi = DataUtil.division((Long)advert, (Long)adx, (int)2);
            retMap.put(key, roi);
        }
        return retMap;
    }

    public static Long nullToDefaultValue(Long value, Long defaultValue) {
        Long ret = value;
        if (value == null || (double)value.longValue() < 0.0) {
            ret = defaultValue;
        }
        return ret;
    }

    public static Map<String, Long> nullToDefaultValue(Map<String, Long> valueMap, Long defaultValue) {
        HashMap<String, Long> retMap = new HashMap<String, Long>();
        for (int i = 0; i < adxPricelevel.length; ++i) {
            if (AssertUtil.isEmpty(valueMap) || valueMap.get(adxPricelevel[i]) == null || (double)valueMap.get(adxPricelevel[i]).longValue() < 0.0) {
                retMap.put(adxPricelevel[i], defaultValue);
                continue;
            }
            retMap.put(adxPricelevel[i], valueMap.get(adxPricelevel[i]));
        }
        return retMap;
    }

    public static void main(String[] args) {
        try {
            HashMap<String, Double> ret1 = new HashMap<String, Double>();
            ret1.put("1", 0.8);
            System.out.println("ret1:" + JSON.toJSONString(ret1));
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setExpStatAllDayAdvertFee(106L);
            adxRoiControlDoInfo1.setExpStatAllDayAdxFee(100L);
            adxRoiControlDoInfo1.setComStatAllDayAdvertFee(100L);
            adxRoiControlDoInfo1.setComStatAllDayAdxFee(100L);
            Map<String, Double> ret2 = AdxRoiFactor.getAdxRoiFactor(1.15, adxRoiControlDoInfo1, null);
            System.out.println("ret2:" + JSON.toJSONString(ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

