package cn.com.duiba.nezha.alg.alg.adx;

import java.util.Map;

import org.slf4j.Logger;
import java.util.HashMap;
import org.slf4j.LoggerFactory;
import com.alibaba.fastjson.JSON;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;

import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.adx.AdxBidding;


public class AdxAlgoBidding {


    //流量分桶Key
    public static String[] adxPricelevel = {"1", "2", "3", "4", "5"};


    /**
     * 流量分桶，流量分组，算法最终出价
     *
     * @param adxDoInfo 人工设置和统计数据
     * @param adxRoiControlDoInfo 人工设置和统计数据
     * @param adxRoiFactor ROI调节因子
     * @return adxPriceLevel, isCompareGroup, adxAlgoPrice（分/千次曝光)
     */


    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo,
                                                      AdxRoiControlDo adxRoiControlDoInfo,
                                                      Map<String, Double> adxRoiFactor) {

        Map<String, String> retMap = new HashMap<>();

        try {

            //设置默认值
            String adxPriceLevel = "1"; //默认分桶
            String isCompareGroup = "0"; //默认分组

            Double defaultPreCtr  = 0.07; //默认ctr
            Double defaultStatClickValue = 0.10*100; //默认点击价值
            Double defaultMinRoi = 1.00; //默认最低ROI
            Double defaultRoiFactor = 1.00; //默认ROI调节因子
            Double compareRate = 0.05; //默认流量分组比例

            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000/(defaultMinRoi * defaultRoiFactor)));



            if (AssertUtil.isAllNotEmpty(adxDoInfo, adxRoiControlDoInfo)) {

                Long defaultPrice = adxRoiControlDoInfo.getDefaultPrice(); //人工设置-默认出价（分/千次曝光）
                Long minPrice = adxRoiControlDoInfo.getMinPrice(); //人工设置-最低出价（分/千次曝光）
                Long maxPrice = adxRoiControlDoInfo.getMaxPrice(); //人工设置-最高出价（分/千次曝光）
                Long minSuccessPrice = adxRoiControlDoInfo.getMinSuccessPrice(); //最低竞价成功出价（分/千次曝光）


                if (AssertUtil.isAllNotEmpty(defaultPrice, minPrice, maxPrice)){

                    if (minSuccessPrice == null || minSuccessPrice < minPrice || minSuccessPrice > defaultPrice){
                        minSuccessPrice = defaultPrice - 1; // 减去1分/千次曝光
                    }


                    /**
                     * 流量分桶（按流量预估出价）
                     */
                    Long[] adxPriceBucket = {minPrice, minSuccessPrice, defaultPrice, maxPrice}; //分桶区间
                    Long adxPrice = AdxBidding.getAdxParPrice(adxDoInfo, defaultRoiFactor); //预估流量出价（分/千次曝光）
                    adxPriceLevel = bucket(adxPrice, adxPriceBucket); //分桶标记


                    /**
                     * 流量分组（1：5%流量,对照组；0：95%流量,实验组）
                     */
                    if (Math.random() <= compareRate) {
                        isCompareGroup = "1";
                    }


                    /**
                     * 算法最终出价（对照组；返回默认出价：实验组：根据ROI调节因子，返回算法出价）
                     */
                    Double roiFactor = defaultRoiFactor;
                    if (adxRoiFactor != null){
                        roiFactor = adxRoiFactor.get(adxPriceLevel);
                        if (roiFactor == null){
                            roiFactor = defaultRoiFactor;
                        }
                    }

                    adxAlgoPrice = defaultPrice;
                    if (isCompareGroup == "0"){
                        adxAlgoPrice =  AdxBidding.getAdxParPrice(adxDoInfo, roiFactor);
                    }

                }
            }

            retMap.put("adxPriceLevel", adxPriceLevel);
            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("adxAlgoPrice", DataUtil.Long2String(adxAlgoPrice));


        } catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }

        return retMap;
    }




    /**
     * 分桶函数
     * <p>
     * 左开又闭区间
     * 其他情况下的闭合区间设计需注意！！
     *
     * @param value
     * @param bucketList 不为空，且不含有空值（未判断）
     * @return
     */
    public static String bucket(Long value, Long[] bucketList) {
        int ret = 1;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; i++) {
                double bound = bucketList[i];

                if (value <= bound) {
                    ret = i + 1;
                    break;
                }
            }

        }
        return adxPricelevel[ret];
    }




    //单元测试
    public static void main(String[] args){

        try {

            Long value1 = 1185L;
            Long[] list1 = {1000L, 1190L, 1180L, 2400L};
            String level1 = bucket(value1, list1);
            System.out.println("level:" + level1);

            AdxDo adxDoInfo1 = new AdxDo();
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            Map<Long, Double> adxRoiFactor1 = new HashMap<>();

            Map<String, String> ret1 = AdxAlgoBidding.getAdxAlgoPrice(null,null,null);
            System.out.println("ret:" + JSON.toJSONString(ret1));

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

}
