/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxBidding;
import cn.com.duiba.nezha.alg.alg.vo.AdxDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxAlgoBidding {
    public static String[] adxPricelevel = new String[]{"1", "2", "3", "4", "5"};
    private static final Logger logger = LoggerFactory.getLogger(AdxAlgoBidding.class);

    public static Map<String, String> getAdxAlgoPrice(AdxDo adxDoInfo, AdxRoiControlDo adxRoiControlDoInfo, Map<String, Double> adxRoiFactor) {
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            String adxPriceLevel = "1";
            String isCompareGroup = "0";
            Double defaultPreCtr = 0.07;
            Double defaultStatClickValue = 10.0;
            Double defaultMinRoi = 1.0;
            Double defaultRoiFactor = 1.0;
            Double compareRate = 0.05;
            Long adxAlgoPrice = Math.round(Math.floor(defaultPreCtr * defaultStatClickValue * 1000.0 / (defaultMinRoi * defaultRoiFactor)));
            if (AssertUtil.isAllNotEmpty((Object[])new Object[]{adxDoInfo, adxRoiControlDoInfo})) {
                Long defaultPrice = adxRoiControlDoInfo.getDefaultPrice();
                Long minPrice = adxRoiControlDoInfo.getMinPrice();
                Long maxPrice = adxRoiControlDoInfo.getMaxPrice();
                Long minSuccessPrice = adxRoiControlDoInfo.getMinSuccessPrice();
                if (AssertUtil.isAllNotEmpty((Object[])new Object[]{defaultPrice, minPrice, maxPrice})) {
                    if (minSuccessPrice == null || minSuccessPrice < minPrice || minSuccessPrice > defaultPrice) {
                        minSuccessPrice = defaultPrice - 1L;
                    }
                    Long[] adxPriceBucket = new Long[]{minPrice, minSuccessPrice, defaultPrice, maxPrice};
                    Long adxPrice = AdxBidding.getAdxParPrice(adxDoInfo, defaultRoiFactor);
                    adxPriceLevel = AdxAlgoBidding.bucket(adxPrice, adxPriceBucket);
                    if (Math.random() <= compareRate) {
                        isCompareGroup = "1";
                    }
                    Double roiFactor = defaultRoiFactor;
                    if (adxRoiFactor != null && (roiFactor = adxRoiFactor.get(adxPriceLevel)) == null) {
                        roiFactor = defaultRoiFactor;
                    }
                    adxAlgoPrice = defaultPrice;
                    if (isCompareGroup == "0") {
                        adxAlgoPrice = AdxBidding.getAdxParPrice(adxDoInfo, roiFactor);
                    }
                }
            }
            retMap.put("adxPriceLevel", adxPriceLevel);
            retMap.put("isCompareGroup", isCompareGroup);
            retMap.put("adxAlgoPrice", DataUtil.Long2String((Long)adxAlgoPrice));
        }
        catch (Exception e) {
            logger.error("AdxAlgoBidding.getAdxAlgoPrice error:" + e);
        }
        return retMap;
    }

    public static String bucket(Long value, Long[] bucketList) {
        int ret = 1;
        if (value != null && bucketList != null && bucketList.length > 0) {
            ret = bucketList.length + 1;
            for (int i = 0; i < bucketList.length; ++i) {
                double bound = bucketList[i].longValue();
                if (!((double)value.longValue() <= bound)) continue;
                ret = i + 1;
                break;
            }
        }
        return adxPricelevel[ret];
    }

    public static void main(String[] args) {
        try {
            Long value1 = 1185L;
            Long[] list1 = new Long[]{1000L, 1190L, 1180L, 2400L};
            String level1 = AdxAlgoBidding.bucket(value1, list1);
            System.out.println("level:" + level1);
            AdxDo adxDoInfo1 = new AdxDo();
            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            HashMap adxRoiFactor1 = new HashMap();
            Map<String, String> ret1 = AdxAlgoBidding.getAdxAlgoPrice(null, null, null);
            System.out.println("ret:" + JSON.toJSONString(ret1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

