/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.bidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.AutoBiddingDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoBidding {
    private static final Logger logger = LoggerFactory.getLogger(AutoBidding.class);
    static double[] ratioBucket = new double[]{0.05, 0.1, 0.3, 0.5, 0.7, 1.0};
    static double[] ratioWeight = new double[]{1.0, 0.9, 0.85, 0.8, 0.75, 0.7};
    static double[] appBcvrControlFactorList = new double[]{0.0, 0.8, 1.0, 1.2};
    static double[] appBcvrControlWeightList = new double[]{0.165, 0.335, 0.335, 0.165};

    public static AutoBiddingDo getFactor(AutoBiddingDo autoBiddingDo) {
        if (autoBiddingDo != null) {
            autoBiddingDo.setAppAfeeFactor(1.0);
        }
        if (!AutoBidding.valid(autoBiddingDo)) {
            logger.warn("AutoBidding.getFactor(AutoBiddingDo autoBiddingDo)  input invalid ,autoBiddingDo=" + JSON.toJSONString((Object)autoBiddingDo));
            return autoBiddingDo;
        }
        Double controlWeight = AutoBidding.getRoulette(appBcvrControlWeightList, appBcvrControlFactorList);
        System.out.println("controlWeight=" + controlWeight);
        Double factor = AutoBidding.getAppFactor(autoBiddingDo, controlWeight);
        autoBiddingDo.setAppAfeeFactor(factor);
        autoBiddingDo.setControlWeight(controlWeight);
        return autoBiddingDo;
    }

    private static Double getAppFactor(AutoBiddingDo autoBiddingDo, Double weight) {
        Double ret = 1.0;
        Double appBasePvRatio = 0.01;
        if (autoBiddingDo.getAdAndappBasePv() != null) {
            appBasePvRatio = DataUtil.division((Long)autoBiddingDo.getAdAndappBasePv(), (Long)autoBiddingDo.getAdBasePv(), (int)3);
            appBasePvRatio = MathBase.noiseSmoother(appBasePvRatio, 0.01, 0.95);
        }
        Double appBcvrRatio = 1.0;
        if (autoBiddingDo.getAdAndappBCvr() != null) {
            appBcvrRatio = DataUtil.division((Double)autoBiddingDo.getAdAndappBCvr(), (Double)autoBiddingDo.getAdBCvr(), (int)3);
            appBcvrRatio = MathBase.noiseSmoother(appBcvrRatio, 0.8, 2.0);
        }
        if (appBcvrRatio < 0.98 && weight > 0.0) {
            weight = 1.0;
        }
        if (appBcvrRatio > 1.0 && weight > 0.0) {
            weight = weight * 1.02;
        }
        Double appBasePvRatioFactor = MathBase.getConfidenceWeight(appBasePvRatio, ratioBucket, ratioWeight);
        Double appBcvrRatioFactor = 1.0 + (appBcvrRatio - 1.0) * weight;
        if (appBasePvRatioFactor != null && appBcvrRatioFactor != null) {
            ret = 1.0 + (appBcvrRatioFactor - 1.0) * appBasePvRatioFactor;
        }
        System.out.println("weight=" + weight);
        System.out.println("appBasePvRatio=" + appBasePvRatio);
        System.out.println("appBcvrRatio=" + appBcvrRatio);
        System.out.println("appBasePvRatioFactor=" + appBasePvRatioFactor);
        System.out.println("appBcvrRatioFactor=" + appBcvrRatioFactor);
        System.out.println("appBasePvRatioFactor=" + appBasePvRatioFactor);
        return ret;
    }

    public static double getRoulette(double[] weightList, double[] factorList) {
        double ret = 1.0;
        double ratio = Math.random();
        double weighAcc = 0.0;
        for (int i = 0; i < weightList.length; ++i) {
            if (!(ratio < (weighAcc += weightList[i]))) continue;
            ret = factorList[i];
            break;
        }
        return ret;
    }

    private static boolean valid(AutoBiddingDo autoBiddingDo) {
        if (autoBiddingDo == null) {
            return false;
        }
        if (autoBiddingDo.getBaseType() == null || autoBiddingDo.getSecondSubType() == null) {
            return false;
        }
        if (autoBiddingDo.getAdBasePv() == null) {
            return false;
        }
        return autoBiddingDo.getAdBCvr() != null;
    }
}

