/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.adx.AdxStatData;
import cn.com.duiba.nezha.alg.alg.adx.StrategyBid;
import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.AdxFlowRateDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxRoiControlDo;
import cn.com.duiba.nezha.alg.alg.vo.AdxStrategyDo;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdxFlowRate {
    private static final Logger logger = LoggerFactory.getLogger(AdxFlowRate.class);

    public static AdxFlowRateDo getAdxFlowRate(AdxRoiControlDo adxRoiControlDoInfo) {
        AdxFlowRateDo ret = new AdxFlowRateDo();
        try {
            Double roiLimit = 0.95;
            Double defaultFlowRate = 0.33;
            Double addStep = 0.3;
            Double cutStep1 = 0.1;
            Double cutStep2 = 0.2;
            Double defaultMinRoi = 1.0;
            Double weightMs = 0.8;
            Double weightDay = 0.2;
            Double secFlowRate = defaultFlowRate;
            Double thiFlowRate = defaultFlowRate;
            ArrayList<Double> scoreList = new ArrayList<Double>();
            ArrayList<Double> roiDiffMsList = new ArrayList<Double>();
            ArrayList<Double> sucRateMsList = new ArrayList<Double>();
            ArrayList<Double> roiDiffDayList = new ArrayList<Double>();
            ArrayList<Double> sucRateDayList = new ArrayList<Double>();
            if (AssertUtil.isNotEmpty((Object)adxRoiControlDoInfo)) {
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);
                if (minRoi != null && minRoi > 1.0) {
                    roiLimit = Math.min(DataUtil.division((Double)1.3, (Double)minRoi), 0.95);
                }
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                for (AdxStrategy strategy : AdxStrategy.values()) {
                    Map<String, Long> strategyStatMs = AdxStatData.getStrategyStatData(strategy.getCode(), strategyMsDoList);
                    Map<String, Long> strategyStatDay = AdxStatData.getStrategyStatData(strategy.getCode(), strategyDayDoList);
                    Double roiMs = AdxStatData.getRoi(strategyStatMs, minRoi);
                    Double sucRateMs = StrategyBid.getSucRate(strategyStatMs);
                    Double roiDiffMs = StrategyBid.nullToDefault(DataUtil.division((Double)roiMs, (Double)minRoi), (Double)0.0);
                    Double flowRateScoreMs = StrategyBid.nullToDefault((roiDiffMs - roiLimit) * sucRateMs, (Double)-1.0);
                    Double roiDay = AdxStatData.getRoi(strategyStatDay, minRoi);
                    Double sucRateDay = StrategyBid.getSucRate(strategyStatDay);
                    Double roiDiffDay = StrategyBid.nullToDefault(DataUtil.division((Double)roiDay, (Double)minRoi), (Double)0.0);
                    Double flowRateScoreDay = StrategyBid.nullToDefault((roiDiffDay - roiLimit) * sucRateDay, (Double)-1.0);
                    Double flowRateScore = weightMs * flowRateScoreMs + weightDay * flowRateScoreDay;
                    int ind = DataUtil.toInt((Long)DataUtil.string2Long((String)strategy.getCode()));
                    scoreList.add(ind - 1, DataUtil.formatDouble((Double)flowRateScore, (int)3));
                    roiDiffMsList.add(ind - 1, DataUtil.formatDouble((Double)roiDiffMs, (int)3));
                    sucRateMsList.add(ind - 1, DataUtil.formatDouble((Double)sucRateMs, (int)3));
                    roiDiffDayList.add(ind - 1, DataUtil.formatDouble((Double)roiDiffDay, (int)3));
                    sucRateDayList.add(ind - 1, DataUtil.formatDouble((Double)sucRateDay, (int)3));
                }
                Long ideaBidCntMs = 0L;
                Long ideaAdxConsumeMs = 0L;
                Map<String, Long> ideaMapInfo = adxRoiControlDoInfo.getIdeaIndexMap();
                if (AssertUtil.isNotEmpty(ideaMapInfo)) {
                    ideaBidCntMs = StrategyBid.nullToDefault(ideaMapInfo.get(AdxIndex.BID.getCode()), 0L);
                    ideaAdxConsumeMs = StrategyBid.nullToDefault(ideaMapInfo.get(AdxIndex.ADX_CONSUME.getCode()), 0L);
                }
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long((String)LocalDateUtil.getCurrentLocalDateTime((String)"HHmm"));
                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null || currentTime >= 0L && currentTime < 20L || ideaBidCntMs < 200L || ideaAdxConsumeMs < 2000000000L) {
                    secFlowRate = defaultFlowRate;
                    thiFlowRate = defaultFlowRate;
                } else {
                    Integer maxInd = scoreList.indexOf(Collections.max(scoreList)) + 1;
                    Integer minInd = scoreList.indexOf(Collections.min(scoreList)) + 1;
                    Integer midInd = 6 - maxInd - minInd;
                    if (maxInd != minInd) {
                        if (maxInd == 2) {
                            secFlowRate = secFlowRate + addStep;
                        } else if (maxInd == 3) {
                            thiFlowRate = thiFlowRate + addStep;
                        }
                        if (midInd == 2) {
                            secFlowRate = secFlowRate - cutStep1;
                        } else if (midInd == 3) {
                            thiFlowRate = thiFlowRate - cutStep1;
                        }
                        if (minInd == 2) {
                            secFlowRate = secFlowRate - cutStep2;
                        } else if (minInd == 3) {
                            thiFlowRate = thiFlowRate - cutStep2;
                        }
                    }
                }
            }
            Double firFlowRate = 1.0 - secFlowRate - thiFlowRate;
            ret.setFirFlowRate(DataUtil.formatDouble((Double)firFlowRate, (int)3));
            ret.setSecFlowRate(DataUtil.formatDouble((Double)secFlowRate, (int)3));
            ret.setThiFlowRate(DataUtil.formatDouble((Double)thiFlowRate, (int)3));
            ret.setScoreList(scoreList);
            ret.setRoiDiffMsList(roiDiffMsList);
            ret.setSucRateMsList(sucRateMsList);
            ret.setRoiDiffDayList(roiDiffDayList);
            ret.setSucRateDayList(sucRateDayList);
        }
        catch (Exception e) {
            logger.error("AdxFlowRate.getAdxFlowRate error:" + e);
        }
        return ret;
    }

    public static void main(String[] args) {
        try {
            ArrayList<Integer> scoreList1 = new ArrayList<Integer>();
            scoreList1.add(0, 1);
            scoreList1.add(1, 2);
            scoreList1.add(2, 2);
            int maxInd1 = scoreList1.indexOf(Collections.max(scoreList1)) + 1;
            int minInd1 = scoreList1.indexOf(Collections.min(scoreList1)) + 1;
            System.out.println("ret2:" + JSON.toJSONString((Object)maxInd1));
            System.out.println("ret2:" + JSON.toJSONString((Object)minInd1));
            String str = "{\"adxFlowRateDo\":{\"firFlowRate\":0.34,\"secFlowRate\":0.331,\"thiFlowRate\":0.331},\"adxRoiFactorDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":34.0,\"adxConsumeDay\":1.22,\"adxConsumeMs\":1.63,\"adxRoiFactor\":0.59001,\"bidCntDay\":55,\"bidCntMs\":56,\"lastRealRoi\":2.014567,\"roiDay\":1.366709,\"roiMs\":2.014567,\"sucBidCntDay\":3,\"sucBidCntMs\":4,\"sucDay\":0.054546,\"sucMs\":0.071429},\"basePrice\":405.0,\"defaultPrice\":1051,\"factorExplorationDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":5.0,\"adxConsumeDay\":0.0,\"adxConsumeMs\":0.82,\"bidCntDay\":0,\"bidCntMs\":13,\"factorExploreMap\":{\"1\":0.84,\"2\":1.0,\"3\":1.050001},\"factorFlowRateMap\":{\"1\":0.66,\"2\":0.141,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.574433,\"2\":1.400002,\"3\":1.377629},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"roiDay\":1.400002,\"roiMs\":1.47603,\"sucBidCntDay\":0,\"sucBidCntMs\":2,\"sucDay\":0.0,\"sucMs\":0.0,\"tryLabel\":1},\"feeType\":2,\"ideaIndexMap\":{\"bidSuc\":7,\"advertConsume\":34,\"adxConsume\":32480000,\"bid\":149,\"exp\":7,\"click\":1},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":34.0,\"adxConsumeDay\":1.22,\"adxConsumeMs\":1.63,\"adxRoiFactor\":0.59001,\"bidCntDay\":55,\"bidCntMs\":56,\"lastRealRoi\":2.014567,\"roiDay\":1.366709,\"roiMs\":2.014567,\"sucBidCntDay\":3,\"sucBidCntMs\":4,\"sucDay\":0.054546,\"sucMs\":0.071429},\"lastFactorExplorationDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":5.0,\"adxConsumeDay\":0.0,\"adxConsumeMs\":0.82,\"bidCntDay\":0,\"bidCntMs\":13,\"factorExploreMap\":{\"1\":0.84,\"2\":1.0,\"3\":1.050001},\"factorFlowRateMap\":{\"1\":0.66,\"2\":0.141,\"3\":0.201},\"lastRealRoiMap\":{\"1\":1.574433,\"2\":1.400002,\"3\":1.377629},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"roiDay\":1.400002,\"roiMs\":1.47603,\"sucBidCntDay\":0,\"sucBidCntMs\":2,\"sucDay\":0.0,\"sucMs\":0.0,\"tryLabel\":1},\"lastMinRoi\":1.4,\"lastPriceExplorationDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":0.0,\"adxConsumeMs\":2.03,\"bidCntDay\":0,\"bidCntMs\":24,\"lastRealRoiMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"priceExploreMap\":{\"1\":998.45,\"2\":1051.0,\"3\":1103.55},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.6,\"3\":0.201},\"roiDay\":1.400002,\"roiMs\":1.345378,\"sucBidCntDay\":0,\"sucBidCntMs\":5,\"sucDay\":0.0,\"sucMs\":0.0,\"tryLabel\":0},\"maxPrice\":2000,\"minPrice\":100,\"minRoi\":1.4,\"priceExplorationDo\":{\"advertConsumeDay\":0.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":0.0,\"adxConsumeMs\":2.03,\"bidCntDay\":0,\"bidCntMs\":24,\"lastRealRoiMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.0,\"3\":0.0},\"priceExploreMap\":{\"1\":998.45,\"2\":1051.0,\"3\":1103.55},\"priceFlowRateMap\":{\"1\":0.201,\"2\":0.6,\"3\":0.201},\"roiDay\":1.400002,\"roiMs\":1.345378,\"sucBidCntDay\":0,\"sucBidCntMs\":5,\"sucDay\":0.0,\"sucMs\":0.0,\"tryLabel\":0},\"resourceIndexMap\":{\"bidSuc\":27,\"advertConsume\":20,\"adxConsume\":109620000,\"bid\":576,\"exp\":27,\"click\":1},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":3,\"advertConsume\":0,\"adxConsume\":12180000,\"bid\":55,\"exp\":3,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":3,\"advertConsume\":0,\"adxConsume\":12180000,\"bid\":45,\"exp\":3,\"click\":1}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":4060000,\"bid\":46,\"exp\":1,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":4,\"advertConsume\":34,\"adxConsume\":16240000,\"bid\":56,\"exp\":4,\"click\":1}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":4060000,\"bid\":4,\"exp\":1,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":3,\"advertConsume\":0,\"adxConsume\":12180000,\"bid\":45,\"exp\":3,\"click\":1}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":4060000,\"bid\":4,\"exp\":1,\"click\":0}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":1,\"advertConsume\":0,\"adxConsume\":4060000,\"bid\":47,\"exp\":1,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            AdxRoiControlDo adxRoiControlDoInfo2 = (AdxRoiControlDo)JSONObject.parseObject((String)str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString((Object)adxRoiControlDoInfo2.getLastAdxRoiFactorDo()));
            AdxFlowRateDo ret2 = AdxFlowRate.getAdxFlowRate(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString((Object)ret2));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

