package cn.com.duiba.nezha.alg.alg.adx;

import cn.com.duiba.nezha.alg.alg.enums.AdxIndex;
import cn.com.duiba.nezha.alg.alg.enums.AdxLevel;
import cn.com.duiba.nezha.alg.alg.enums.AdxStrategy;
import cn.com.duiba.nezha.alg.alg.vo.*;
import cn.com.duiba.nezha.alg.common.enums.DateStyle;
import cn.com.duiba.nezha.alg.common.util.AssertUtil;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import cn.com.duiba.nezha.alg.common.util.LocalDateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import javafx.beans.binding.DoubleExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


public class PriceExploration {


    /**
     * 策略2-价格试探（根据缓存数据，调用频率：20min调用1次）
     *
     * @param adxRoiControlDoInfo 人工设置，统计数据，上一次缓存数据
     * @return 价格试探表, 调节主要依据
     */


    private static final Logger logger = LoggerFactory.getLogger(PriceExploration.class);

    public static AdxPriceExplorationDo getExplorePrice(AdxRoiControlDo adxRoiControlDoInfo) {

        AdxPriceExplorationDo ret = new AdxPriceExplorationDo();


        /**
         *
         * 步骤：
         * 步骤1、设置默认值
         * 步骤2、当前对象是否合法
         * 步骤3、计算统计数据
         * 步骤4、判断启动状态tryLabel
         * 步骤5、判断基准值是否重置/更新
         * 步骤6、试价幅度调节
         * 步骤7、试价流量分配
         * 步骤8、更新上一次实际ROI
         *
         */


        try {


            // 1、设置默认值
            Double defaultPrice = 10.0;                               // 默认出价（分/cpm）
            Double defaultMinRoi = 1.0;                               // 默认最低ROI

            Double[] stepList = {0.95, 1.00, 1.05};                   // 基准值调节步长
            //Double[] diffList = {0.02, 0.05, 0.08, 0.10};
            Double[] diffList = {0.02, 0.05, 0.08, 0.10, 0.15, 0.20, 0.30};  // ROI偏差分桶值

            Double baseValue = defaultPrice;                          // 基准值
            Double[] baseFlowRate = {0.2, 0.6, 0.2};                  // 基准流量比例
            Double[] lastRealRoi = {0.0, 0.0, 0.0};                   // 默认上一次实际roi
            Double[] lastRealSucRate = {0.0, 0.0, 0.0};               // 默认上一次成功率


            //adx价格试探表
            Map<String, Double> priceMap = new HashMap<>((AdxLevel.values().length - 1));
            Map<String, Double> flowRateMap = new HashMap<>((AdxLevel.values().length - 1));
            Map<String, Double> lastRoiMap = new HashMap<>((AdxLevel.values().length - 1));
            Map<String, Double> lastSucRateMap = new HashMap<>((AdxLevel.values().length - 1));

            Long tryLabel = 0L;                                       // 冷启动试探标记
            Double upLimitBidFee = null;                              // 竞价约束上限
            Long lastTryLabel = 0L;                                   // 上一次冷启动试探标记

            //调节主要依据
            Long bidCntMs = 0L;
            Long sucBidCntMs = 0L;
            Double roiDay = 0.0;
            Double sucRateDay = 0.0;
            Double adxConsumeDay = 0.0;
            Double advertConsumeMs = 0.0;

            Long bidCntDay = 0L;
            Long sucBidCntDay = 0L;
            Double roiMs = 0.0;
            Double sucRateMs = 0.0;
            Double adxConsumeMs = 0.0;
            Double advertConsumeDay = 0.0;


            //2、当前对象是否合法
            if (AssertUtil.isNotEmpty(adxRoiControlDoInfo)) {

                //人工设置ROI
                Double minRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinRoi(), defaultMinRoi);

                //3、计算统计数据
                Long defaultCnt = 0L;
                Long defaultConsume = 0L;
                ArrayList<AdxStrategyDo> strategyMsDoList = adxRoiControlDoInfo.getStrategyMsDoList();
                List<AdxLevelDo> strategySecMs = StrategyBid.getStrategyInfo(strategyMsDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());
                ArrayList<AdxStrategyDo> strategyDayDoList = adxRoiControlDoInfo.getStrategyDayDoList();
                List<AdxLevelDo> strategySecDay = StrategyBid.getStrategyInfo(strategyDayDoList, AdxStrategy.ADX_STRATEGY_SEC.getCode());

                //策略2-分level-实时-ROI(置信),竞价成功率,竞价成功量级，adx消耗(分*10000/cpm)
                Map<String, Double> sucRateLevelMs = StrategyBid.getLevelSucRate(strategySecMs);
                Map<String, Long> sucCntLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                Map<String, Long> adxConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume);
                Map<String, Long> advertConsumeLevelMs = StrategyBid.getLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume);
                //分level-实时-ROI(置信处理)
                Map<String, Double> roiRealLevelMs = StrategyBid.getLevelRoi(strategySecMs,minRoi);
                //分level-实时-ROI(纠偏处理)
                Map<String, Double> roiLevelMs = StrategyBid.getRoiPriceRectify(roiRealLevelMs, adxConsumeLevelMs, adxRoiControlDoInfo);


                //策略2-实时-ROI,竞价成功率,竞价量级,竞价成功量级.adx消耗(分),广告消耗
                roiMs = StrategyBid.getRoi(strategySecMs, minRoi);
                sucRateMs = StrategyBid.getSucRate(strategySecMs);
                bidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntMs = StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeMs = DataUtil.division(StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), 10000 * 1000L, 2);
                advertConsumeMs = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategySecMs, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));

                //策略2-全天累计-ROI,竞价成功率,竞价量级,竞价成功量级.adx消耗(分),广告消耗
                roiDay = StrategyBid.getRoi(strategySecDay, minRoi);
                sucRateDay = StrategyBid.getSucRate(strategySecDay);
                bidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID.getCode(), defaultCnt);
                sucBidCntDay = StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.BID_SUC.getCode(), defaultCnt);
                adxConsumeDay = DataUtil.division(StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADX_CONSUME.getCode(), defaultConsume), 10000 * 1000L, 2);
                advertConsumeDay = DataUtil.toDouble(StrategyBid.getSumLevelIndex(strategySecDay, AdxIndex.ADVERT_CONSUME.getCode(), defaultConsume));

                //资源位维度-实时-ROI,竞价成功率
                Double resoRoiMs = 0.0;
                Double resoSucRateMs = 0.0;
                Map<String, Long> resoMapInfo = adxRoiControlDoInfo.getResourceIndexMap();
                if (AssertUtil.isNotEmpty(resoMapInfo)) {
                    resoRoiMs = StrategyBid.getRoi(resoMapInfo, minRoi);
                    resoSucRateMs = StrategyBid.getSucRate(resoMapInfo);
                }

                //默认出价(分/cpm)(100分)
                defaultPrice = DataUtil.toDouble(StrategyBid.nullToDefault(adxRoiControlDoInfo.getDefaultPrice(), 10L));
                //出价下限(分/cpm)(1分)
                Double minPrice = DataUtil.toDouble(StrategyBid.nullToDefault(adxRoiControlDoInfo.getMinPrice(), 1L));
                //出价上限(分/cpm)(默认出价+1分)
                Double maxPrice = DataUtil.toDouble(StrategyBid.nullToDefault(adxRoiControlDoInfo.getMaxPrice(), ((DataUtil.double2Long(defaultPrice)) + 1L)));
                //底价(分/cpm)(可能为null/0)
                Double basePrice = adxRoiControlDoInfo.getBasePrice();
                //扣费方式：1:一价扣费，2:二价扣费
                Integer feeType = adxRoiControlDoInfo.getFeeType();


                //4、判断启动状态tryLabel：0-正常；1-试探；2-回归(不在投放时间段,实时竞价量级为0)
                if (bidCntMs == 0L) {

                    tryLabel = 2L;

                } else {

                    // 试探组数据不置信；基准level数据不置信 并且 涨价level的roi<0.95
                    if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 0.05
                            && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < 200 * 1000 * 10000L) {

                        tryLabel = 1L;

                    } else {

                        if (sucRateLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 0.05
                                && adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_TWO.getCode()) < 200 * 1000 * 10000L) {

                            if (roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) < minRoi * 0.95) {

                                tryLabel = 1L;

                            }
                        }
                    }

                }


                //5、判断调节因子是否重置/更新
                baseValue = defaultPrice;
                Double lowValue = baseValue * 0.95;  //获得降价level的出价
                Double uppValue = baseValue * 1.05;  //获得涨价level的出价
                Double diff = DataUtil.division(roiMs, minRoi, 3);

                //5.1、重置--人工设置ROI与上一次ROI不相同; 更新时间为00:00:00-00:20:00;全天累计竞价量级为0;
                Double lastMinRoi = StrategyBid.nullToDefault(adxRoiControlDoInfo.getLastMinRoi(), defaultMinRoi);
                Long currentTime = DataUtil.string2Long(LocalDateUtil.getCurrentLocalDateTime("HHmm"));

                if (minRoi.compareTo(lastMinRoi) != 0 || currentTime == null
                        || (currentTime >= 0L && currentTime < 20L)
                        || bidCntDay == 0L) {

                    baseValue = defaultPrice;

                } else {


                    //5.2、最优出价：增量1，权重1; 竞价约束上限更新
                    Double incre1 = 1.00;
                    AdxPriceExplorationDo lastPriceDoInfo = adxRoiControlDoInfo.getLastPriceExplorationDo();

                    if (AssertUtil.isNotEmpty(lastPriceDoInfo)) {

                        Map<String, Double> lastPriceMap = lastPriceDoInfo.getPriceExploreMap();
                        String bestLevel = StrategyBid.selectBestLevel(minRoi, roiLevelMs, sucRateLevelMs);
                        lastTryLabel = lastPriceDoInfo.getTryLabel();

                        if (AssertUtil.isNotEmpty(lastPriceMap)) {

                            if (lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode()) != null) {
                                //获得基准出价
                                baseValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_TWO.getCode());
                                //获得降价level的出价
                                lowValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_ONE.getCode());
                                //获得涨价level的出价
                                uppValue = lastPriceMap.get(AdxLevel.ADX_LEVEL_THR.getCode());

                            }


                            //获取当前最优出价约束
                            upLimitBidFee = StrategyBid.selectUpLimitFee(lastPriceMap, sucRateLevelMs, lastPriceDoInfo.getUpLimitBidFee());

                            //增量1
                            if (lastPriceMap.get(bestLevel) != null) {
                                incre1 = DataUtil.division(lastPriceMap.get(bestLevel), baseValue, 3);
                            }

                        }

                    }


                    //不在投放时间段，基准值回归至默认值
                    if (tryLabel == 2L) {

                        Double baseDiff = DataUtil.division(baseValue, defaultPrice) - 1.0;
                        baseValue -= defaultPrice * baseDiff * 0.20;


                    } else {

                        //权重1
                        Double weight1 = 1.00;
                        if (sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05) {
                            weight1 = 0.0;
                        } else {
                            weight1 = diff < 0.6 ? 0.0 : (diff < 0.8 ? 0.5 : (diff < 0.9 ? 0.8 : 1.0));
                        }


                        //5.3、维稳调控：增量2，权重2
                        Double incre2 = 1.00;
                        if (roiMs > 0.0) {
                            incre2 = DataUtil.division(roiMs, (minRoi * 0.98), 3);

                            //墨迹：参照max(历史策略ROI，实时策略ROI)
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {
                                Double roiStable = StrategyBid.getRemainStableRoi(roiDay, roiMs, minRoi, 0.98);
                                incre2 = DataUtil.division(roiStable, (minRoi * 0.98), 3);
                            }

                            Double weight2 = 1.00;
                            if (sucRateMs < 0.03 || sucRateMs < resoSucRateMs * 0.05) {
                                weight2 = 0.0;
                            } else {
                                //weight2 = diff < 0.95 ? 0.7 : (diff < 1.05 ? 0.5 : 0.8);
                                weight2 = 1.0;
                            }

                            //根据全天累计ROI确定维稳范围
                            Double remainStableLimit = StrategyBid.getRemainStableLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);

                            incre1 = StrategyBid.getNormalValue(incre1, 1.00, 0.90, 1.10);
                            incre2 = StrategyBid.getNormalValue(incre2, 1.00, (1 - remainStableLimit), (1 + remainStableLimit));
                            Double incre = 1 + (incre1 - 1) * weight1 * 0.5 + (incre2 - 1) * weight2 * 0.5;

                            //只根据维稳增量调节：最优出价不置信；策略ROI>目标*1.3
                            if (weight1 == 0.0 || diff > 1.3) {
                                incre = 1 + (incre2 - 1) * weight2;
                            }
                            Double coeff = StrategyBid.bucket(Math.abs(diff - 1.0), diffList);


                            //5.4、基准出价是否更新
                            // 冷启动:不更新；
                            // 非冷启动：更新;
                            // 一价计费：最优出价约束
                            if (tryLabel == 0L) {

                                Double MojiRoiLimit = StrategyBid.getMojiRoiLimit(roiDay, minRoi, sucRateDay, resoSucRateMs, adxConsumeDay);

                                //墨迹-非冷启动：不更新(基准level数据置信 and ROI在目标MojiRoiLimit-1.00);
                                if (upLimitBidFee != null && feeType != null && feeType == 1) {

                                    if (StrategyBid.getBaseLevelConfident(resoSucRateMs, sucRateLevelMs, adxConsumeLevelMs) == 1L
                                            && roiMs >= minRoi * MojiRoiLimit && roiMs <= minRoi) {

                                        baseValue = Math.max(upLimitBidFee, baseValue);

                                    } else {

                                        baseValue = StrategyBid.getNormalValue((baseValue * incre), defaultPrice, (baseValue * (1.0 - coeff)), (baseValue * (1.0 + coeff)));
                                    }

                                } else {

                                    baseValue = StrategyBid.getNormalValue((baseValue * incre), defaultPrice, (baseValue * (1.0 - coeff)), (baseValue * (1.0 + coeff)));

                                }

                            }


                            // 冷启动跳转正常启动,用试探level更新basevalue
                            if (lastTryLabel == 1L && tryLabel == 0L) {
                                baseValue = uppValue;
                            }

                            // 策略ROI>目标*1.3，基准level调价要到底价以上；
                            if (basePrice != null && basePrice > 0.0 && diff > 1.3) {
                                baseValue = Math.max(basePrice, baseValue);
                            }


                            //针对墨迹一价计费，更新基准出价
                            if (upLimitBidFee != null && feeType != null && feeType == 1) {

                                //连续冷启动并且实时涨价level roi>目标*0.95
                                if (lastTryLabel == 1L && tryLabel == 1L && roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()) > minRoi * 0.95) {

                                    baseValue = uppValue;
                                }

                                baseValue = Math.min(upLimitBidFee, baseValue);// lwj 20190724

                            }

                        }

                    }


                    // 6、试价幅度调节
                    if (tryLabel == 2L) {

                        //涨价幅度
                        Double uppDiff = DataUtil.division(uppValue, defaultPrice) - 1.0;
                        stepList[2] = DataUtil.division((uppValue - defaultPrice * uppDiff * 0.20), baseValue);

                        //降价幅度
                        Double lowDiff = DataUtil.division(lowValue, defaultPrice) - 1.0;
                        stepList[0] = DataUtil.division((lowValue - defaultPrice * lowDiff * 0.20), baseValue);


                    } else if (tryLabel == 1L) {

                        //降价幅度
                        stepList[0] = DataUtil.division(lowValue, baseValue);

                        //涨价幅度
                        Double uppSuc = DataUtil.division(sucRateLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), Math.max(resoSucRateMs, 0.10), 3);
                        Double stepSuc = uppSuc < 0.1 ? 0.10 : (uppSuc < 0.3 ? 0.08 : (uppSuc < 0.5 ? 0.05 : (uppSuc < 0.7 ? -0.05 : (uppSuc < 0.9 ? -0.08 : -0.10))));

                        Double uppDiff = DataUtil.division(roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), minRoi, 3);
                        Double stepRoi = uppDiff < 0.8 ? -0.08 : (uppDiff < 0.95 ? -0.06 : (uppDiff < 1.05 ? 0.05 : (uppDiff < 1.20 ? 0.06 : 0.08)));

                        if (adxConsumeMs == 0.0) {
                            stepSuc = 0.1;
                            stepRoi = 0.1;
                        }

                        stepList[2] = Math.max((DataUtil.division(uppValue, baseValue) + 0.5 * stepSuc + 0.5 * stepRoi), 1.0);


                    } else {

                        //涨价幅度
                        stepList[2] += diff < 1.05 ? -0.03 : (diff < 1.1 ? -0.02 : (diff < 1.2 ? 0.00 : (diff < 1.3 ? 0.03 : 0.05)));
                        //降价幅度
                        stepList[0] -= diff < 0.7 ? 0.05 : (diff < 0.8 ? 0.03 : (diff < 0.9 ? 0.00 : (diff < 0.95 ? -0.02 : -0.03)));

                    }


                    /**
                     * 最高桶出价约束：不低于 底价；不超过 出价限制(正常启动,冷启动)
                     */
                    if (upLimitBidFee != null) {
                        stepList[2] = Math.min(stepList[2], DataUtil.division(upLimitBidFee, baseValue));
                    }

                    if (basePrice != null && basePrice > 0.0) {
                        stepList[2] = Math.max(stepList[2], DataUtil.division(basePrice, baseValue));
                    }




                    //7、试探流量分配
                    if (tryLabel == 2L) {

                        //涨价占比
                        baseFlowRate[2] = 0.2;
                        //降价占比
                        baseFlowRate[0] = 0.2;


                    } else if (tryLabel == 1L) {

                        //涨价占比
                        Double tryDiff = DataUtil.division(roiRealLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()), minRoi,3);
                        baseFlowRate[2] = StrategyBid.getTryFlowRate(tryDiff, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                        //降价占比
                        baseFlowRate[0] = 0.2;


                        //针对墨迹一价计费, 冷启动时，涨价流量随ROI调节，没有降价流量
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {

                            //涨价占比
                            baseFlowRate[2] = StrategyBid.getMojiTryFlowRate(roiDay, roiMs, minRoi, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            //降价占比
                            baseFlowRate[0] = 0.0;
                        }


                    } else {

                        if (diff < 0.9) {

                            //涨价占比
                            baseFlowRate[2] = 0.1;
                            //降价占比
                            baseFlowRate[0] = diff < 0.8 ? 0.3 : 0.2;

                        } else if (diff > 1.1) {

                            //涨价占比
                            baseFlowRate[2] = diff < 1.2 ? 0.2 : 0.3;
                            //降价占比
                            baseFlowRate[0] = 0.1;

                        } else if (diff > 0.95 && diff < 1.05) {

                            //涨价占比
                            baseFlowRate[2] = 0.10;
                            //降价占比
                            baseFlowRate[0] = 0.10;

                        } else {

                            //涨价占比
                            baseFlowRate[2] = 0.15;
                            //降价占比
                            baseFlowRate[0] = 0.15;

                        }


                        //针对墨迹一价计费，正常启动时，涨价流量随ROI调节，没有降价流量
                        if (upLimitBidFee != null && feeType != null && feeType == 1) {

                            //涨价占比
                            baseFlowRate[2] = StrategyBid.getMojiNormalFlowRate(roiDay, roiMs, minRoi, adxConsumeLevelMs.get(AdxLevel.ADX_LEVEL_THR.getCode()));
                            //降价占比
                            baseFlowRate[0] = 0.00;
                        }

                    }

                    baseFlowRate[1] = DataUtil.formatDouble((1.0 - baseFlowRate[0] - baseFlowRate[2]), 3);


                    //8、更新上一次实际ROI和竞价成功率
                    for (int i = 1; i < AdxLevel.values().length; i++) {
                        lastRealRoi[i - 1] = roiLevelMs.get(DataUtil.Integer2String(i));
                        lastRealSucRate[i - 1] = sucRateLevelMs.get(DataUtil.Integer2String(i));

                        //ROI：冷启动-未纠偏
                        if (tryLabel == 1L) {
                            lastRealRoi[i - 1] = roiRealLevelMs.get(DataUtil.Integer2String(i));
                        }
                    }

                }
            }


            for (AdxLevel adxLevel : AdxLevel.values()) {
                String key = adxLevel.getCode();
                if (!key.equals(AdxLevel.ADX_LEVEL_ZER.getCode())) {
                    int i = DataUtil.toInt(DataUtil.string2Long(key));
                    Double price = DataUtil.formatDouble((baseValue * stepList[i - 1]),3);
                    Double flowRate = DataUtil.formatDouble(baseFlowRate[i - 1],3);
                    Double lastRoi = lastRealRoi[i - 1];
                    Double lastSucRate = lastRealSucRate[i - 1];

                    priceMap.put(key, price);
                    flowRateMap.put(key, flowRate);
                    lastRoiMap.put(key, lastRoi);
                    lastSucRateMap.put(key, lastSucRate);
                }
            }

            ret.setPriceExploreMap(priceMap);
            ret.setPriceFlowRateMap(flowRateMap);
            ret.setLastRealRoiMap(lastRoiMap);
            ret.setLastSucRateMap(lastSucRateMap);
            ret.setTryLabel(tryLabel);
            ret.setUpLimitBidFee(upLimitBidFee);

            ret.setRoiDay(roiDay);
            ret.setSucDay(sucRateDay);
            ret.setBidCntDay(bidCntDay);
            ret.setSucBidCntDay(sucBidCntDay);
            ret.setAdxConsumeDay(adxConsumeDay);
            ret.setAdvertConsumeDay(advertConsumeDay);

            ret.setRoiMs(roiMs);
            ret.setSucMs(sucRateMs);
            ret.setBidCntMs(bidCntMs);
            ret.setSucBidCntMs(sucBidCntMs);
            ret.setAdxConsumeMs(adxConsumeMs);
            ret.setAdvertConsumeMs(advertConsumeMs);


        } catch (Exception e) {
            logger.error("PriceExploration.getExplorePrice error:" + e);
        }

        return ret;
    }


    //单元测试
    public static void main(String[] args) {

        try {

            AdxRoiControlDo adxRoiControlDoInfo1 = new AdxRoiControlDo();
            adxRoiControlDoInfo1.setDefaultPrice(1400L);
            adxRoiControlDoInfo1.setMinPrice(1000L);
            adxRoiControlDoInfo1.setMaxPrice(2000L);
            adxRoiControlDoInfo1.setStrategy("1");
            adxRoiControlDoInfo1.setLastMinRoi(1.20);
            adxRoiControlDoInfo1.setMinRoi(1.20);


            Map<String, Long> ideaIndexMap1 = new HashMap<>();
            ideaIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            ideaIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            ideaIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            ideaIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            ideaIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800 * 10000 * 100L);
            ideaIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);

            Map<String, Long> resourceIndexMap1 = new HashMap<>();
            resourceIndexMap1.put(AdxIndex.BID.getCode(), 2000L);
            resourceIndexMap1.put(AdxIndex.BID_SUC.getCode(), 1500L);
            resourceIndexMap1.put(AdxIndex.EXP.getCode(), 1000L);
            resourceIndexMap1.put(AdxIndex.CLICK.getCode(), 800L);
            resourceIndexMap1.put(AdxIndex.ADX_CONSUME.getCode(), 800 * 10000 * 100L);
            resourceIndexMap1.put(AdxIndex.ADVERT_CONSUME.getCode(), 900L);

            adxRoiControlDoInfo1.setIdeaIndexMap(ideaIndexMap1);
            adxRoiControlDoInfo1.setResourceIndexMap(resourceIndexMap1);


            String str =
                    "{\"adxFlowRateDo\":{\"firFlowRate\":0.243,\"roiDiffDayList\":[0.539,0.637,0.506],\"roiDiffMsList\":[1.0,1.26,0.368],\"scoreList\":[-0.073,-0.016,-0.139],\"secFlowRate\":0.335,\"sucRateDayList\":[0.266,0.536,0.303],\"sucRateMsList\":[0.002,0.947,0.295],\"thiFlowRate\":0.423},\"adxRoiFactorDo\":{\"advertConsumeDay\":466.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":623.0,\"adxConsumeMs\":5.0,\"adxRoiFactor\":0.720026,\"bidCntDay\":10652,\"bidCntMs\":722,\"lastRealRoi\":1.272728,\"roiDay\":0.747994,\"roiMs\":1.272728,\"sucBidCntDay\":2642,\"sucBidCntMs\":19,\"sucDay\":0.248029,\"sucMs\":0.026316},\"basePrice\":1000.0,\"defaultPrice\":1000,\"factorExplorationDo\":{\"advertConsumeDay\":640.0,\"advertConsumeMs\":51.0,\"adxConsumeDay\":904.0,\"adxConsumeMs\":87.0,\"bidCntDay\":12546,\"bidCntMs\":1505,\"factorExploreMap\":{\"1\":0.88277,\"2\":0.90277,\"3\":1.00277},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.707589,\"2\":0.728572,\"3\":0.749556},\"lastSucRateMap\":{\"1\":0.301283,\"2\":0.27764,\"3\":0.226028},\"roiDay\":0.707965,\"roiMs\":0.586208,\"sucBidCntDay\":3790,\"sucBidCntMs\":414,\"sucDay\":0.302089,\"sucMs\":0.275084,\"tryLabel\":0},\"feeType\":1,\"ideaIndexMap\":{\"bidSuc\":1122,\"advertConsume\":130,\"adxConsume\":3240000000,\"bid\":3178,\"exp\":324,\"click\":12},\"lastAdxRoiFactorDo\":{\"advertConsumeDay\":466.0,\"advertConsumeMs\":0.0,\"adxConsumeDay\":623.0,\"adxConsumeMs\":5.0,\"adxRoiFactor\":0.720026,\"bidCntDay\":10652,\"bidCntMs\":722,\"lastRealRoi\":1.272728,\"roiDay\":0.747994,\"roiMs\":1.272728,\"sucBidCntDay\":2642,\"sucBidCntMs\":19,\"sucDay\":0.248029,\"sucMs\":0.026316},\"lastFactorExplorationDo\":{\"advertConsumeDay\":640.0,\"advertConsumeMs\":51.0,\"adxConsumeDay\":904.0,\"adxConsumeMs\":87.0,\"bidCntDay\":12546,\"bidCntMs\":1505,\"factorExploreMap\":{\"1\":0.88277,\"2\":0.90277,\"3\":1.00277},\"factorFlowRateMap\":{\"1\":0.101,\"2\":0.6,\"3\":0.3},\"lastRealRoiMap\":{\"1\":0.707589,\"2\":0.728572,\"3\":0.749556},\"lastSucRateMap\":{\"1\":0.301283,\"2\":0.27764,\"3\":0.226028},\"roiDay\":0.707965,\"roiMs\":0.586208,\"sucBidCntDay\":3790,\"sucBidCntMs\":414,\"sucDay\":0.302089,\"sucMs\":0.275084,\"tryLabel\":0},\"lastMinRoi\":1.4,\"lastPriceExplorationDo\":{\"advertConsumeDay\":1123.0,\"advertConsumeMs\":312.0,\"adxConsumeDay\":1260.46,\"adxConsumeMs\":170.0,\"bidCntDay\":9179,\"bidCntMs\":706,\"lastRealRoiMap\":{\"1\":2.290415,\"2\":2.244606,\"3\":2.244606},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.946181,\"3\":0.961539},\"priceExploreMap\":{\"1\":980.0,\"2\":1000.0,\"3\":1000.0},\"priceFlowRateMap\":{\"1\":0.0,\"2\":0.797,\"3\":0.205},\"roiDay\":0.890952,\"roiMs\":1.835295,\"sucBidCntDay\":4917,\"sucBidCntMs\":670,\"sucDay\":0.53568,\"sucMs\":0.949009,\"tryLabel\":0,\"upLimitBidFee\":1000.0},\"maxPrice\":1100,\"minPrice\":200,\"minRoi\":1.4,\"priceExplorationDo\":{\"advertConsumeDay\":1123.0,\"advertConsumeMs\":312.0,\"adxConsumeDay\":1260.46,\"adxConsumeMs\":170.0,\"bidCntDay\":9179,\"bidCntMs\":706,\"lastRealRoiMap\":{\"1\":2.290415,\"2\":2.244606,\"3\":2.244606},\"lastSucRateMap\":{\"1\":0.0,\"2\":0.946181,\"3\":0.961539},\"priceExploreMap\":{\"1\":980.0,\"2\":1000.0,\"3\":1000.0},\"priceFlowRateMap\":{\"1\":0.0,\"2\":0.797,\"3\":0.205},\"roiDay\":0.890952,\"roiMs\":1.835295,\"sucBidCntDay\":4917,\"sucBidCntMs\":670,\"sucDay\":0.53568,\"sucMs\":0.949009,\"tryLabel\":0,\"upLimitBidFee\":1000.0},\"resourceIndexMap\":{\"bidSuc\":5950,\"advertConsume\":1517,\"adxConsume\":15010000000,\"bid\":8609,\"exp\":1501,\"click\":56},\"strategyDayDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":2642,\"advertConsume\":466,\"adxConsume\":6230000000,\"bid\":10652,\"exp\":623,\"click\":20}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":3845,\"advertConsume\":727,\"adxConsume\":9960000000,\"bid\":8076,\"exp\":996,\"click\":26}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":2129,\"advertConsume\":526,\"adxConsume\":5504500000,\"bid\":2225,\"exp\":549,\"click\":19}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":1206,\"advertConsume\":204,\"adxConsume\":3050000000,\"bid\":4311,\"exp\":305,\"click\":10}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":2544,\"advertConsume\":332,\"adxConsume\":6240000000,\"bid\":7080,\"exp\":624,\"click\":16}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":194,\"advertConsume\":104,\"adxConsume\":450000000,\"bid\":2627,\"exp\":45,\"click\":2}}],\"strategy\":\"3\"}],\"strategyMsDoList\":[{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":15,\"advertConsume\":0,\"adxConsume\":50000000,\"bid\":721,\"exp\":5,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}}],\"strategy\":\"1\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":780,\"advertConsume\":90,\"adxConsume\":2110000000,\"bid\":829,\"exp\":211,\"click\":8}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":200,\"advertConsume\":40,\"adxConsume\":520000000,\"bid\":208,\"exp\":52,\"click\":4}}],\"strategy\":\"2\"},{\"levelDoList\":[{\"level\":\"0\",\"valueMap\":{\"bidSuc\":0,\"advertConsume\":0,\"adxConsume\":0,\"bid\":0,\"exp\":0,\"click\":0}},{\"level\":\"1\",\"valueMap\":{\"bidSuc\":20,\"advertConsume\":0,\"adxConsume\":80000000,\"bid\":136,\"exp\":8,\"click\":0}},{\"level\":\"2\",\"valueMap\":{\"bidSuc\":58,\"advertConsume\":0,\"adxConsume\":400000000,\"bid\":819,\"exp\":40,\"click\":0}},{\"level\":\"3\",\"valueMap\":{\"bidSuc\":15,\"advertConsume\":0,\"adxConsume\":70000000,\"bid\":396,\"exp\":7,\"click\":0}}],\"strategy\":\"3\"}]}\n";
            //JSONObject object = JSON.parseObject(str);
            AdxRoiControlDo adxRoiControlDoInfo2 = JSONObject.parseObject(str, AdxRoiControlDo.class);
            System.out.println("lastPriceExplorationDo:" + JSON.toJSONString(adxRoiControlDoInfo2.getLastPriceExplorationDo()));

            AdxPriceExplorationDo ret2 = PriceExploration.getExplorePrice(adxRoiControlDoInfo2);
            System.out.println("ret2:" + JSON.toJSONString(ret2));


        } catch (Exception e) {
            e.printStackTrace();
        }

    }
}
