package cn.com.duiba.nezha.alg.alg.adx.rcmd;

import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaParamsDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxIdeaStatDo;
import cn.com.duiba.nezha.alg.alg.vo.adx.AdxResourceRcmdDo;

import java.util.List;
import java.util.Map;

public class AdxIdeaRcmdAlg {


    /**
     * 定时任务 流量分配
     *
     * @param ideaList              资源下，算法组创意集合（开启）
     * @param adxMinStatDoMap       创意统计数据 20分钟
     * @param adxDayStatDoMap       创意统计数据 3天
     * @param lastAdxResourceRcmdDo 上一次输出对象（资源位创意推荐对象）
     * @return
     */
    public static AdxResourceRcmdDo trafficAllocation(List<Long> ideaList,
                                                      Map<Long, AdxIdeaStatDo> adxMinStatDoMap,
                                                      Map<Long, AdxIdeaStatDo> adxDayStatDoMap,
                                                      AdxResourceRcmdDo lastAdxResourceRcmdDo) {
        return AdxIdeaRcmder.trafficAllocation(ideaList, adxMinStatDoMap, adxDayStatDoMap, lastAdxResourceRcmdDo);
    }

    /**
     * 创意推荐
     *
     * @param validIdeaList     有效创意集合
     * @param adxResourceRcmdDo 资源位创意推荐对象
     * @return 创意
     */
    public static Long ideaRcmd(List<Long> validIdeaList, AdxResourceRcmdDo adxResourceRcmdDo) {

        return AdxIdeaRcmder.ideaRcmd(validIdeaList, adxResourceRcmdDo);
    }
}
