package cn.com.duiba.nezha.alg.alg.bidding;

import cn.com.duiba.nezha.alg.alg.base.MathBase;
import cn.com.duiba.nezha.alg.alg.vo.AutoBiddingDo;
import cn.com.duiba.nezha.alg.common.util.DataUtil;
import com.alibaba.fastjson.JSON;
import org.slf4j.LoggerFactory;

public class AutoBidding {

    private static final org.slf4j.Logger logger = LoggerFactory.getLogger(AutoBidding.class);

    /**
     * 媒体转化-占比
     */
    static double[] ratioBucket = {0.05, 0.1, 0.3, 0.5, 0.7, 1.0};


    /**
     * 媒体转化-占比-调节力度
     */
    static double[] ratioWeight = {1, 0.9, 0.85, 0.80, 0.75, 0.70};


    /**
     * 媒体转化率控制因子
     */
    static double[] appBcvrControlFactorList = {0, 0.8, 1.0, 1.2};

    /**
     * 媒体转化率控制因子权重
     */
    static double[] appBcvrControlWeightList = {0.165, 0.335, 0.335, 0.165};


    /**
     * OCPA-分媒体自动目标转化出价
     *
     * @param autoBiddingDo
     * @return
     */
    public static AutoBiddingDo getFactor(AutoBiddingDo autoBiddingDo) {

        // 初始化默认值
        if (autoBiddingDo != null) {
            autoBiddingDo.setAppAfeeFactor(1.0);
        }

        //判断输入是否合法
        if (!valid(autoBiddingDo)) {
            logger.warn("AutoBidding.getFactor(AutoBiddingDo autoBiddingDo)  input invalid ,autoBiddingDo=" + JSON.toJSONString(autoBiddingDo));
            return autoBiddingDo;
        }

        // 随机选择控制幅度
        Double controlWeight = getRoulette(appBcvrControlWeightList, appBcvrControlFactorList);

        System.out.println("controlWeight=" + controlWeight);

        // 计算调节因子
        Double factor = getAppFactor(autoBiddingDo, controlWeight);

        // 更新调节因子
        autoBiddingDo.setAppAfeeFactor(factor);

        autoBiddingDo.setControlWeight(controlWeight);

        // 返回
        return autoBiddingDo;

    }

    private static Double getAppFactor(AutoBiddingDo autoBiddingDo, Double weight) {
        Double ret = 1.0;


        // 媒体转化占比
        Double appBasePvRatio = 0.01;
        if (autoBiddingDo.getAdAndappBasePv() != null) {
            appBasePvRatio = DataUtil.division(autoBiddingDo.getAdAndappBasePv(), autoBiddingDo.getAdBasePv(), 3);
            // 区间约束
            appBasePvRatio = MathBase.noiseSmoother(appBasePvRatio, 0.01, 0.95);
        }


        // 媒体转化率比例
        Double appBcvrRatio = 1.0;
        if (autoBiddingDo.getAdAndappBCvr() != null) {
            appBcvrRatio = DataUtil.division(autoBiddingDo.getAdAndappBCvr(), autoBiddingDo.getAdBCvr(), 3);
            // 区间约束
            appBcvrRatio = MathBase.noiseSmoother(appBcvrRatio, 0.8, 2.0);
        }

        if (appBcvrRatio < 0.98 && weight > 0) {
            weight = 1.0;
        }

        if (appBcvrRatio > 1.0 && weight > 0) {
            weight = weight * 1.01;
        }

        // 媒体占比调节因子
        Double appBasePvRatioFactor = MathBase.getConfidenceWeight(appBasePvRatio, ratioBucket, ratioWeight);




        // 媒体转化率调节因子
        Double appBcvrRatioFactor = 1 + (appBcvrRatio - 0.98) * weight;


        // 调节因子
        if (appBasePvRatioFactor != null && appBcvrRatioFactor != null) {

            ret = 1 + (appBcvrRatioFactor - 1) * appBasePvRatioFactor;
        }

        System.out.println("weight=" + weight);
        System.out.println("appBasePvRatio=" + appBasePvRatio);
        System.out.println("appBcvrRatio=" + appBcvrRatio);
        System.out.println("appBasePvRatioFactor=" + appBasePvRatioFactor);
        System.out.println("appBcvrRatioFactor=" + appBcvrRatioFactor);
        System.out.println("appBasePvRatioFactor=" + appBasePvRatioFactor);
        return ret;
    }


    public static double getRoulette(double[] weightList, double[] factorList) {
        double ret = 1;
        double ratio = Math.random();
        double weighAcc = 0;
        for (int i = 0; i < weightList.length; i++) {
            weighAcc += weightList[i];
            if (ratio < weighAcc) {
                ret = factorList[i];
                break;
            }
        }

        return ret;
    }

    private static boolean valid(AutoBiddingDo autoBiddingDo) {

        if (autoBiddingDo == null) {
            return false;
        }


        if (autoBiddingDo.getBaseType() == null || autoBiddingDo.getSecondSubType() == null) {
            return false;
        }
        if (autoBiddingDo.getAdBasePv() == null) {
            return false;
        }
        if (autoBiddingDo.getAdBCvr() == null) {
            return false;
        }

        return true;

    }
}
